/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.changes;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.changedetection.changes.StatefulIncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RebuildIncrementalTaskInputs
extends StatefulIncrementalTaskInputs {
    private static final Logger LOGGER = LoggerFactory.getLogger(RebuildIncrementalTaskInputs.class);
    private final Iterable<? extends FileCollectionFingerprint> fingerprints;

    public RebuildIncrementalTaskInputs(Task task, Iterable<? extends FileCollectionFingerprint> fingerprints) {
        LOGGER.info("All input files are considered out-of-date for incremental {}.", (Object)task);
        this.fingerprints = fingerprints;
    }

    public boolean isIncremental() {
        return false;
    }

    @Override
    public void doOutOfDate(Action<? super InputFileDetails> outOfDateAction) {
        for (FileCollectionFingerprint fileCollectionFingerprint : this.fingerprints) {
            for (String path : fileCollectionFingerprint.getFingerprints().keySet()) {
                outOfDateAction.execute((Object)new RebuildInputFile(new File(path)));
            }
        }
    }

    @Override
    public void doRemoved(Action<? super InputFileDetails> removedAction) {
    }

    private static class RebuildInputFile
    implements InputFileDetails {
        private final File file;

        private RebuildInputFile(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public boolean isAdded() {
            return false;
        }

        public boolean isModified() {
            return false;
        }

        public boolean isRemoved() {
            return false;
        }
    }
}

