/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.datafeed;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.metrics.max.MaxAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.ml.MlParserType;
import org.elasticsearch.xpack.core.ml.datafeed.ChunkingConfig;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.ExtractorUtils;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.MlStrings;
import org.elasticsearch.xpack.core.ml.utils.time.TimeUtils;

public class DatafeedConfig
extends AbstractDiffable<DatafeedConfig>
implements ToXContentObject {
    public static final int DEFAULT_SCROLL_SIZE = 1000;
    private static final int SECONDS_IN_MINUTE = 60;
    private static final int TWO_MINS_SECONDS = 120;
    private static final int TWENTY_MINS_SECONDS = 1200;
    private static final int HALF_DAY_SECONDS = 43200;
    public static final ParseField RESULTS_FIELD = new ParseField("datafeeds", new String[0]);
    public static final String DOC_COUNT = "doc_count";
    public static final ParseField ID = new ParseField("datafeed_id", new String[0]);
    public static final ParseField QUERY_DELAY = new ParseField("query_delay", new String[0]);
    public static final ParseField FREQUENCY = new ParseField("frequency", new String[0]);
    public static final ParseField INDEXES = new ParseField("indexes", new String[0]);
    public static final ParseField INDICES = new ParseField("indices", new String[0]);
    public static final ParseField TYPES = new ParseField("types", new String[0]);
    public static final ParseField QUERY = new ParseField("query", new String[0]);
    public static final ParseField SCROLL_SIZE = new ParseField("scroll_size", new String[0]);
    public static final ParseField AGGREGATIONS = new ParseField("aggregations", new String[0]);
    public static final ParseField AGGS = new ParseField("aggs", new String[0]);
    public static final ParseField SCRIPT_FIELDS = new ParseField("script_fields", new String[0]);
    public static final ParseField SOURCE = new ParseField("_source", new String[0]);
    public static final ParseField CHUNKING_CONFIG = new ParseField("chunking_config", new String[0]);
    public static final ParseField HEADERS = new ParseField("headers", new String[0]);
    public static final ObjectParser<Builder, Void> METADATA_PARSER = new ObjectParser("datafeed_config", true, Builder::new);
    public static final ObjectParser<Builder, Void> CONFIG_PARSER = new ObjectParser("datafeed_config", false, Builder::new);
    public static final Map<MlParserType, ObjectParser<Builder, Void>> PARSERS = new EnumMap<MlParserType, ObjectParser<Builder, Void>>(MlParserType.class);
    private final String id;
    private final String jobId;
    private final TimeValue queryDelay;
    private final TimeValue frequency;
    private final List<String> indices;
    private final List<String> types;
    private final QueryBuilder query;
    private final AggregatorFactories.Builder aggregations;
    private final List<SearchSourceBuilder.ScriptField> scriptFields;
    private final Integer scrollSize;
    private final ChunkingConfig chunkingConfig;
    private final Map<String, String> headers;

    private DatafeedConfig(String id, String jobId, TimeValue queryDelay, TimeValue frequency, List<String> indices, List<String> types, QueryBuilder query, AggregatorFactories.Builder aggregations, List<SearchSourceBuilder.ScriptField> scriptFields, Integer scrollSize, ChunkingConfig chunkingConfig, Map<String, String> headers) {
        this.id = id;
        this.jobId = jobId;
        this.queryDelay = queryDelay;
        this.frequency = frequency;
        this.indices = indices;
        this.types = types;
        this.query = query;
        this.aggregations = aggregations;
        this.scriptFields = scriptFields;
        this.scrollSize = scrollSize;
        this.chunkingConfig = chunkingConfig;
        this.headers = Objects.requireNonNull(headers);
    }

    public DatafeedConfig(StreamInput in) throws IOException {
        this.id = in.readString();
        this.jobId = in.readString();
        this.queryDelay = in.readOptionalTimeValue();
        this.frequency = in.readOptionalTimeValue();
        this.indices = in.readBoolean() ? in.readList(StreamInput::readString) : null;
        this.types = in.readBoolean() ? in.readList(StreamInput::readString) : null;
        this.query = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
        this.aggregations = (AggregatorFactories.Builder)in.readOptionalWriteable(AggregatorFactories.Builder::new);
        this.scriptFields = in.readBoolean() ? in.readList(SearchSourceBuilder.ScriptField::new) : null;
        this.scrollSize = in.readOptionalVInt();
        if (in.getVersion().before(Version.V_5_5_0)) {
            in.readBoolean();
        }
        this.chunkingConfig = (ChunkingConfig)in.readOptionalWriteable(ChunkingConfig::new);
        this.headers = in.getVersion().onOrAfter(Version.V_6_2_0) ? in.readMap(StreamInput::readString, StreamInput::readString) : Collections.emptyMap();
    }

    public String getId() {
        return this.id;
    }

    public String getJobId() {
        return this.jobId;
    }

    public TimeValue getQueryDelay() {
        return this.queryDelay;
    }

    public TimeValue getFrequency() {
        return this.frequency;
    }

    public List<String> getIndices() {
        return this.indices;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public Integer getScrollSize() {
        return this.scrollSize;
    }

    public QueryBuilder getQuery() {
        return this.query;
    }

    public AggregatorFactories.Builder getAggregations() {
        return this.aggregations;
    }

    public long getHistogramIntervalMillis() {
        return ExtractorUtils.getHistogramIntervalMillis(this.aggregations);
    }

    public boolean hasAggregations() {
        return this.aggregations != null && this.aggregations.count() > 0;
    }

    public List<SearchSourceBuilder.ScriptField> getScriptFields() {
        return this.scriptFields == null ? Collections.emptyList() : this.scriptFields;
    }

    public ChunkingConfig getChunkingConfig() {
        return this.chunkingConfig;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeString(this.jobId);
        out.writeOptionalTimeValue(this.queryDelay);
        out.writeOptionalTimeValue(this.frequency);
        if (this.indices != null) {
            out.writeBoolean(true);
            out.writeStringList(this.indices);
        } else {
            out.writeBoolean(false);
        }
        if (this.types != null) {
            out.writeBoolean(true);
            out.writeStringList(this.types);
        } else {
            out.writeBoolean(false);
        }
        out.writeNamedWriteable((NamedWriteable)this.query);
        out.writeOptionalWriteable((Writeable)this.aggregations);
        if (this.scriptFields != null) {
            out.writeBoolean(true);
            out.writeList(this.scriptFields);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalVInt(this.scrollSize);
        if (out.getVersion().before(Version.V_5_5_0)) {
            out.writeBoolean(false);
        }
        out.writeOptionalWriteable((Writeable)this.chunkingConfig);
        if (out.getVersion().onOrAfter(Version.V_6_2_0)) {
            out.writeMap(this.headers, StreamOutput::writeString, StreamOutput::writeString);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(ID.getPreferredName(), this.id);
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(QUERY_DELAY.getPreferredName(), this.queryDelay.getStringRep());
        if (this.frequency != null) {
            builder.field(FREQUENCY.getPreferredName(), this.frequency.getStringRep());
        }
        builder.field(INDICES.getPreferredName(), this.indices);
        builder.field(TYPES.getPreferredName(), this.types);
        builder.field(QUERY.getPreferredName(), (ToXContent)this.query);
        if (this.aggregations != null) {
            builder.field(AGGREGATIONS.getPreferredName(), (ToXContent)this.aggregations);
        }
        if (this.scriptFields != null) {
            builder.startObject(SCRIPT_FIELDS.getPreferredName());
            for (SearchSourceBuilder.ScriptField scriptField : this.scriptFields) {
                scriptField.toXContent(builder, params);
            }
            builder.endObject();
        }
        builder.field(SCROLL_SIZE.getPreferredName(), this.scrollSize);
        if (this.chunkingConfig != null) {
            builder.field(CHUNKING_CONFIG.getPreferredName(), (ToXContent)this.chunkingConfig);
        }
        if (!this.headers.isEmpty() && params.paramAsBoolean("for_cluster_state", false)) {
            builder.field(HEADERS.getPreferredName(), this.headers);
        }
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DatafeedConfig)) {
            return false;
        }
        DatafeedConfig that = (DatafeedConfig)((Object)other);
        return Objects.equals(this.id, that.id) && Objects.equals(this.jobId, that.jobId) && Objects.equals(this.frequency, that.frequency) && Objects.equals(this.queryDelay, that.queryDelay) && Objects.equals(this.indices, that.indices) && Objects.equals(this.types, that.types) && Objects.equals(this.query, that.query) && Objects.equals(this.scrollSize, that.scrollSize) && Objects.equals(this.aggregations, that.aggregations) && Objects.equals(this.scriptFields, that.scriptFields) && Objects.equals(this.chunkingConfig, that.chunkingConfig) && Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.jobId, this.frequency, this.queryDelay, this.indices, this.types, this.query, this.scrollSize, this.aggregations, this.scriptFields, this.chunkingConfig, this.headers);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public TimeValue defaultFrequency(TimeValue bucketSpan) {
        TimeValue defaultFrequency = this.defaultFrequencyTarget(bucketSpan);
        if (this.hasAggregations()) {
            long targetFrequencyMillis;
            long histogramIntervalMillis = this.getHistogramIntervalMillis();
            long defaultFrequencyMillis = histogramIntervalMillis > (targetFrequencyMillis = defaultFrequency.millis()) ? histogramIntervalMillis : targetFrequencyMillis / histogramIntervalMillis * histogramIntervalMillis;
            defaultFrequency = TimeValue.timeValueMillis((long)defaultFrequencyMillis);
        }
        return defaultFrequency;
    }

    private TimeValue defaultFrequencyTarget(TimeValue bucketSpan) {
        long bucketSpanSeconds = bucketSpan.seconds();
        if (bucketSpanSeconds <= 0L) {
            throw new IllegalArgumentException("Bucket span has to be > 0");
        }
        if (bucketSpanSeconds <= 120L) {
            return TimeValue.timeValueSeconds((long)60L);
        }
        if (bucketSpanSeconds <= 1200L) {
            return TimeValue.timeValueSeconds((long)(bucketSpanSeconds / 2L));
        }
        if (bucketSpanSeconds <= 43200L) {
            return TimeValue.timeValueMinutes((long)10L);
        }
        return TimeValue.timeValueHours((long)1L);
    }

    static {
        PARSERS.put(MlParserType.METADATA, METADATA_PARSER);
        PARSERS.put(MlParserType.CONFIG, CONFIG_PARSER);
        for (MlParserType parserType : MlParserType.values()) {
            ObjectParser<Builder, Void> parser = PARSERS.get((Object)parserType);
            assert (parser != null);
            parser.declareString(Builder::setId, ID);
            parser.declareString(Builder::setJobId, Job.ID);
            parser.declareStringArray(Builder::setIndices, INDEXES);
            parser.declareStringArray(Builder::setIndices, INDICES);
            parser.declareStringArray(Builder::setTypes, TYPES);
            parser.declareString((builder, val) -> builder.setQueryDelay(TimeValue.parseTimeValue((String)val, (String)QUERY_DELAY.getPreferredName())), QUERY_DELAY);
            parser.declareString((builder, val) -> builder.setFrequency(TimeValue.parseTimeValue((String)val, (String)FREQUENCY.getPreferredName())), FREQUENCY);
            parser.declareObject(Builder::setQuery, (p, c) -> AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)p), QUERY);
            parser.declareObject(Builder::setAggregations, (p, c) -> AggregatorFactories.parseAggregators((XContentParser)p), AGGREGATIONS);
            parser.declareObject(Builder::setAggregations, (p, c) -> AggregatorFactories.parseAggregators((XContentParser)p), AGGS);
            parser.declareObject(Builder::setScriptFields, (p, c) -> {
                ArrayList<SearchSourceBuilder.ScriptField> parsedScriptFields = new ArrayList<SearchSourceBuilder.ScriptField>();
                while (p.nextToken() != XContentParser.Token.END_OBJECT) {
                    parsedScriptFields.add(new SearchSourceBuilder.ScriptField(p));
                }
                parsedScriptFields.sort(Comparator.comparing(SearchSourceBuilder.ScriptField::fieldName));
                return parsedScriptFields;
            }, SCRIPT_FIELDS);
            parser.declareInt(Builder::setScrollSize, SCROLL_SIZE);
            parser.declareBoolean((builder, value) -> {}, SOURCE);
            parser.declareObject(Builder::setChunkingConfig, (ContextParser)ChunkingConfig.PARSERS.get((Object)parserType), CHUNKING_CONFIG);
        }
        METADATA_PARSER.declareObject(Builder::setHeaders, (p, c) -> p.mapStrings(), HEADERS);
    }

    public static class Builder {
        private static final TimeValue MIN_DEFAULT_QUERY_DELAY = TimeValue.timeValueMinutes((long)1L);
        private static final TimeValue MAX_DEFAULT_QUERY_DELAY = TimeValue.timeValueMinutes((long)2L);
        private static final int DEFAULT_AGGREGATION_CHUNKING_BUCKETS = 1000;
        private String id;
        private String jobId;
        private TimeValue queryDelay;
        private TimeValue frequency;
        private List<String> indices = Collections.emptyList();
        private List<String> types = Collections.emptyList();
        private QueryBuilder query = QueryBuilders.matchAllQuery();
        private AggregatorFactories.Builder aggregations;
        private List<SearchSourceBuilder.ScriptField> scriptFields;
        private Integer scrollSize = 1000;
        private ChunkingConfig chunkingConfig;
        private Map<String, String> headers = Collections.emptyMap();

        public Builder() {
        }

        public Builder(String id, String jobId) {
            this();
            this.id = ExceptionsHelper.requireNonNull(id, ID.getPreferredName());
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
        }

        public Builder(DatafeedConfig config) {
            this.id = config.id;
            this.jobId = config.jobId;
            this.queryDelay = config.queryDelay;
            this.frequency = config.frequency;
            this.indices = config.indices;
            this.types = config.types;
            this.query = config.query;
            this.aggregations = config.aggregations;
            this.scriptFields = config.scriptFields;
            this.scrollSize = config.scrollSize;
            this.chunkingConfig = config.chunkingConfig;
            this.headers = config.headers;
        }

        public void setId(String datafeedId) {
            this.id = ExceptionsHelper.requireNonNull(datafeedId, ID.getPreferredName());
        }

        public void setJobId(String jobId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
        }

        public void setHeaders(Map<String, String> headers) {
            this.headers = ExceptionsHelper.requireNonNull(headers, HEADERS.getPreferredName());
        }

        public void setIndices(List<String> indices) {
            this.indices = ExceptionsHelper.requireNonNull(indices, INDICES.getPreferredName());
        }

        public void setTypes(List<String> types) {
            this.types = ExceptionsHelper.requireNonNull(types, TYPES.getPreferredName());
        }

        public void setQueryDelay(TimeValue queryDelay) {
            TimeUtils.checkNonNegativeMultiple(queryDelay, TimeUnit.MILLISECONDS, QUERY_DELAY);
            this.queryDelay = queryDelay;
        }

        public void setFrequency(TimeValue frequency) {
            TimeUtils.checkPositiveMultiple(frequency, TimeUnit.SECONDS, FREQUENCY);
            this.frequency = frequency;
        }

        public void setQuery(QueryBuilder query) {
            this.query = ExceptionsHelper.requireNonNull(query, QUERY.getPreferredName());
        }

        public void setAggregations(AggregatorFactories.Builder aggregations) {
            this.aggregations = aggregations;
        }

        public void setScriptFields(List<SearchSourceBuilder.ScriptField> scriptFields) {
            ArrayList<SearchSourceBuilder.ScriptField> sorted = new ArrayList<SearchSourceBuilder.ScriptField>();
            for (SearchSourceBuilder.ScriptField scriptField : scriptFields) {
                sorted.add(scriptField);
            }
            sorted.sort(Comparator.comparing(SearchSourceBuilder.ScriptField::fieldName));
            this.scriptFields = sorted;
        }

        public void setScrollSize(int scrollSize) {
            if (scrollSize < 0) {
                String msg = Messages.getMessage("Invalid {0} value ''{1}'' in datafeed configuration", SCROLL_SIZE.getPreferredName(), scrollSize);
                throw ExceptionsHelper.badRequestException(msg, new Object[0]);
            }
            this.scrollSize = scrollSize;
        }

        public void setChunkingConfig(ChunkingConfig chunkingConfig) {
            this.chunkingConfig = chunkingConfig;
        }

        public DatafeedConfig build() {
            ExceptionsHelper.requireNonNull(this.id, ID.getPreferredName());
            ExceptionsHelper.requireNonNull(this.jobId, Job.ID.getPreferredName());
            if (!MlStrings.isValidId(this.id)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("Invalid {0}; ''{1}'' can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with alphanumeric", ID.getPreferredName(), this.id), new Object[0]);
            }
            if (this.indices == null || this.indices.isEmpty() || this.indices.contains(null) || this.indices.contains("")) {
                throw Builder.invalidOptionValue(INDICES.getPreferredName(), this.indices);
            }
            if (this.types == null || this.types.contains(null) || this.types.contains("")) {
                throw Builder.invalidOptionValue(TYPES.getPreferredName(), this.types);
            }
            this.validateAggregations();
            this.setDefaultChunkingConfig();
            this.setDefaultQueryDelay();
            return new DatafeedConfig(this.id, this.jobId, this.queryDelay, this.frequency, this.indices, this.types, this.query, this.aggregations, this.scriptFields, this.scrollSize, this.chunkingConfig, this.headers);
        }

        void validateAggregations() {
            if (this.aggregations == null) {
                return;
            }
            if (this.scriptFields != null && !this.scriptFields.isEmpty()) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("script_fields cannot be used in combination with aggregations"), new Object[0]);
            }
            List aggregatorFactories = this.aggregations.getAggregatorFactories();
            if (aggregatorFactories.isEmpty()) {
                throw ExceptionsHelper.badRequestException("A date_histogram (or histogram) aggregation is required", new Object[0]);
            }
            AggregationBuilder histogramAggregation = ExtractorUtils.getHistogramAggregation(aggregatorFactories);
            Builder.checkNoMoreHistogramAggregations(histogramAggregation.getSubAggregations());
            Builder.checkHistogramAggregationHasChildMaxTimeAgg(histogramAggregation);
            Builder.checkHistogramIntervalIsPositive(histogramAggregation);
        }

        private static void checkNoMoreHistogramAggregations(List<AggregationBuilder> aggregations) {
            for (AggregationBuilder agg : aggregations) {
                if (ExtractorUtils.isHistogram(agg)) {
                    throw ExceptionsHelper.badRequestException("Aggregations can only have 1 date_histogram or histogram aggregation", new Object[0]);
                }
                Builder.checkNoMoreHistogramAggregations(agg.getSubAggregations());
            }
        }

        static void checkHistogramAggregationHasChildMaxTimeAgg(AggregationBuilder histogramAggregation) {
            String timeField = null;
            if (histogramAggregation instanceof ValuesSourceAggregationBuilder) {
                timeField = ((ValuesSourceAggregationBuilder)histogramAggregation).field();
            }
            for (AggregationBuilder agg : histogramAggregation.getSubAggregations()) {
                MaxAggregationBuilder maxAgg;
                if (!(agg instanceof MaxAggregationBuilder) || !(maxAgg = (MaxAggregationBuilder)agg).field().equals(timeField)) continue;
                return;
            }
            throw ExceptionsHelper.badRequestException(Messages.getMessage("Date histogram must have nested max aggregation for time_field [{0}]", timeField), new Object[0]);
        }

        private static void checkHistogramIntervalIsPositive(AggregationBuilder histogramAggregation) {
            long interval = ExtractorUtils.getHistogramIntervalMillis(histogramAggregation);
            if (interval <= 0L) {
                throw ExceptionsHelper.badRequestException("Aggregation interval must be greater than 0", new Object[0]);
            }
        }

        private void setDefaultChunkingConfig() {
            if (this.chunkingConfig == null) {
                if (this.aggregations == null) {
                    this.chunkingConfig = ChunkingConfig.newAuto();
                } else {
                    long histogramIntervalMillis = ExtractorUtils.getHistogramIntervalMillis(this.aggregations);
                    this.chunkingConfig = ChunkingConfig.newManual(TimeValue.timeValueMillis((long)(1000L * histogramIntervalMillis)));
                }
            }
        }

        private void setDefaultQueryDelay() {
            if (this.queryDelay == null) {
                Random random = new Random(this.jobId.hashCode());
                long delayMillis = random.longs(MIN_DEFAULT_QUERY_DELAY.millis(), MAX_DEFAULT_QUERY_DELAY.millis()).findFirst().getAsLong();
                this.queryDelay = TimeValue.timeValueMillis((long)delayMillis);
            }
        }

        private static ElasticsearchException invalidOptionValue(String fieldName, Object value) {
            String msg = Messages.getMessage("Invalid {0} value ''{1}'' in datafeed configuration", fieldName, value);
            throw ExceptionsHelper.badRequestException(msg, new Object[0]);
        }
    }
}

