/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.time.Clock;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.LicensesMetaData;
import org.elasticsearch.license.PostStartTrialRequest;
import org.elasticsearch.license.PostStartTrialResponse;
import org.elasticsearch.license.SelfGeneratedLicense;
import org.elasticsearch.xpack.core.XPackPlugin;

public class StartTrialClusterTask
extends ClusterStateUpdateTask {
    private static final String ACKNOWLEDGEMENT_HEADER = "This API initiates a free 30-day trial for all platinum features. By starting this trial, you agree that it is subject to the terms and conditions at https://www.elastic.co/legal/trial_license/. To begin your free trial, call /start_trial again and specify the \"acknowledge=true\" parameter.";
    private static final Map<String, String[]> ACK_MESSAGES = Collections.singletonMap("security", new String[]{"With a trial license, X-Pack security features are available, but are not enabled by default."});
    private final Logger logger;
    private final String clusterName;
    private final PostStartTrialRequest request;
    private final ActionListener<PostStartTrialResponse> listener;
    private final Clock clock;

    StartTrialClusterTask(Logger logger, String clusterName, Clock clock, PostStartTrialRequest request, ActionListener<PostStartTrialResponse> listener) {
        this.logger = logger;
        this.clusterName = clusterName;
        this.request = request;
        this.listener = listener;
        this.clock = clock;
    }

    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
        LicensesMetaData oldLicensesMetaData = (LicensesMetaData)oldState.metaData().custom("licenses");
        this.logger.debug("started self generated trial license: {}", (Object)oldLicensesMetaData);
        if (!this.request.isAcknowledged()) {
            this.listener.onResponse((Object)new PostStartTrialResponse(PostStartTrialResponse.Status.NEED_ACKNOWLEDGEMENT, ACK_MESSAGES, ACKNOWLEDGEMENT_HEADER));
        } else if (oldLicensesMetaData == null || oldLicensesMetaData.isEligibleForTrial()) {
            this.listener.onResponse((Object)new PostStartTrialResponse(PostStartTrialResponse.Status.UPGRADED_TO_TRIAL));
        } else {
            this.listener.onResponse((Object)new PostStartTrialResponse(PostStartTrialResponse.Status.TRIAL_ALREADY_ACTIVATED));
        }
    }

    public ClusterState execute(ClusterState currentState) throws Exception {
        XPackPlugin.checkReadyForXPackCustomMetadata(currentState);
        LicensesMetaData currentLicensesMetaData = (LicensesMetaData)currentState.metaData().custom("licenses");
        if (!this.request.isAcknowledged()) {
            return currentState;
        }
        if (currentLicensesMetaData == null || currentLicensesMetaData.isEligibleForTrial()) {
            long issueDate = this.clock.millis();
            MetaData.Builder mdBuilder = MetaData.builder((MetaData)currentState.metaData());
            long expiryDate = issueDate + LicenseService.NON_BASIC_SELF_GENERATED_LICENSE_DURATION.getMillis();
            License.Builder specBuilder = License.builder().uid(UUID.randomUUID().toString()).issuedTo(this.clusterName).maxNodes(1000).issueDate(issueDate).type(this.request.getType()).expiryDate(expiryDate);
            License selfGeneratedLicense = SelfGeneratedLicense.create(specBuilder);
            LicensesMetaData newLicensesMetaData = new LicensesMetaData(selfGeneratedLicense, Version.CURRENT);
            mdBuilder.putCustom("licenses", (MetaData.Custom)newLicensesMetaData);
            return ClusterState.builder((ClusterState)currentState).metaData(mdBuilder).build();
        }
        return currentState;
    }

    public void onFailure(String source, @Nullable Exception e) {
        this.logger.error((Message)new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
        this.listener.onFailure(e);
    }
}

