/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.rest;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ccr.action.PutFollowAction;

public class RestPutFollowAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_ccr/follow"));
    }

    public String getName() {
        return "ccr_put_follow_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        PutFollowAction.Request request = RestPutFollowAction.createRequest(restRequest);
        return channel -> client.execute((ActionType)PutFollowAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }

    private static PutFollowAction.Request createRequest(RestRequest restRequest) throws IOException {
        try (XContentParser parser = restRequest.contentOrSourceParamParser();){
            ActiveShardCount waitForActiveShards = ActiveShardCount.parseString((String)restRequest.param("wait_for_active_shards"));
            PutFollowAction.Request request = PutFollowAction.Request.fromXContent((XContentParser)parser, (String)restRequest.param("index"), (ActiveShardCount)waitForActiveShards);
            return request;
        }
    }
}

