/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm;

import java.io.Closeable;
import java.time.Clock;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.OperationMode;
import org.elasticsearch.xpack.core.scheduler.CronSchedule;
import org.elasticsearch.xpack.core.scheduler.SchedulerEngine;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicy;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicyMetadata;
import org.elasticsearch.xpack.ilm.OperationModeUpdateTask;
import org.elasticsearch.xpack.slm.SnapshotLifecycleTask;

public class SnapshotLifecycleService
implements Closeable,
ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(SnapshotLifecycleService.class);
    private static final String JOB_PATTERN_SUFFIX = "-\\d+$";
    private final SchedulerEngine scheduler;
    private final ClusterService clusterService;
    private final SnapshotLifecycleTask snapshotTask;
    private final Map<String, SchedulerEngine.Job> scheduledTasks = ConcurrentCollections.newConcurrentMap();
    private final AtomicBoolean running = new AtomicBoolean(true);
    private volatile boolean isMaster = false;

    public SnapshotLifecycleService(Settings settings, Supplier<SnapshotLifecycleTask> taskSupplier, ClusterService clusterService, Clock clock) {
        this.scheduler = new SchedulerEngine(settings, clock);
        this.clusterService = clusterService;
        this.snapshotTask = taskSupplier.get();
    }

    public void init() {
        this.clusterService.addListener((ClusterStateListener)this);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        boolean prevIsMaster = this.isMaster;
        if (prevIsMaster != event.localNodeMaster()) {
            this.isMaster = event.localNodeMaster();
            if (this.isMaster) {
                this.scheduler.register((SchedulerEngine.Listener)this.snapshotTask);
            } else {
                this.scheduler.unregister((SchedulerEngine.Listener)this.snapshotTask);
                this.cancelSnapshotJobs();
            }
        }
        if (this.isMaster) {
            ClusterState state = event.state();
            if (SnapshotLifecycleService.slmStoppedOrStopping(state)) {
                if (this.scheduler.scheduledJobIds().size() > 0) {
                    this.cancelSnapshotJobs();
                }
                if (SnapshotLifecycleService.slmStopping(state)) {
                    this.submitOperationModeUpdate(OperationMode.STOPPED);
                }
                return;
            }
            this.scheduleSnapshotJobs(state);
            this.cleanupDeletedPolicies(state);
        }
    }

    SchedulerEngine getScheduler() {
        return this.scheduler;
    }

    static boolean slmStoppedOrStopping(ClusterState state) {
        return Optional.ofNullable((SnapshotLifecycleMetadata)state.metadata().custom("snapshot_lifecycle")).map(SnapshotLifecycleMetadata::getOperationMode).map(mode -> OperationMode.STOPPING == mode || OperationMode.STOPPED == mode).orElse(false);
    }

    static boolean slmStopping(ClusterState state) {
        return Optional.ofNullable((SnapshotLifecycleMetadata)state.metadata().custom("snapshot_lifecycle")).map(SnapshotLifecycleMetadata::getOperationMode).map(mode -> OperationMode.STOPPING == mode).orElse(false);
    }

    public void submitOperationModeUpdate(OperationMode mode) {
        this.clusterService.submitStateUpdateTask("slm_operation_mode_update", (ClusterStateTaskConfig)OperationModeUpdateTask.slmMode(mode));
    }

    public void scheduleSnapshotJobs(ClusterState state) {
        SnapshotLifecycleMetadata snapMeta = (SnapshotLifecycleMetadata)state.metadata().custom("snapshot_lifecycle");
        if (snapMeta != null) {
            snapMeta.getSnapshotConfigurations().values().forEach(this::maybeScheduleSnapshot);
        }
    }

    public void cleanupDeletedPolicies(ClusterState state) {
        SnapshotLifecycleMetadata snapMeta = (SnapshotLifecycleMetadata)state.metadata().custom("snapshot_lifecycle");
        if (snapMeta != null) {
            Set policyJobIds = snapMeta.getSnapshotConfigurations().values().stream().map(SnapshotLifecycleService::getJobId).collect(Collectors.toSet());
            this.scheduledTasks.keySet().stream().filter(jobId -> !policyJobIds.contains(jobId)).forEach(this::cancelScheduledSnapshot);
        }
    }

    public void maybeScheduleSnapshot(SnapshotLifecyclePolicyMetadata snapshotLifecyclePolicy) {
        if (!this.running.get()) {
            return;
        }
        String jobId = SnapshotLifecycleService.getJobId(snapshotLifecyclePolicy);
        Pattern existingJobPattern = Pattern.compile(snapshotLifecyclePolicy.getPolicy().getId() + JOB_PATTERN_SUFFIX);
        boolean existingJobsFoundAndCancelled = this.scheduledTasks.keySet().stream().filter(jId -> existingJobPattern.matcher((CharSequence)jId).matches()).filter(jId -> !jId.equals(jobId)).map(existingJobId -> {
            logger.debug("removing existing snapshot lifecycle job [{}] as it has been updated", existingJobId);
            this.scheduledTasks.remove(existingJobId);
            boolean existed = this.scheduler.remove(existingJobId);
            assert (existed) : "expected job for " + existingJobId + " to exist in scheduler";
            return existed;
        }).reduce(false, (a, b) -> a != false || b != false);
        this.scheduledTasks.computeIfAbsent(jobId, id -> {
            SchedulerEngine.Job job = new SchedulerEngine.Job(jobId, (SchedulerEngine.Schedule)new CronSchedule(snapshotLifecyclePolicy.getPolicy().getSchedule()));
            if (existingJobsFoundAndCancelled) {
                logger.info("rescheduling updated snapshot lifecycle job [{}]", (Object)jobId);
            } else {
                logger.info("scheduling snapshot lifecycle job [{}]", (Object)jobId);
            }
            this.scheduler.add(job);
            return job;
        });
    }

    public static String getJobId(SnapshotLifecyclePolicyMetadata policyMeta) {
        return policyMeta.getPolicy().getId() + "-" + policyMeta.getVersion();
    }

    public void cancelSnapshotJobs() {
        logger.trace("cancelling all snapshot lifecycle jobs");
        this.scheduler.scheduledJobIds().forEach(arg_0 -> ((SchedulerEngine)this.scheduler).remove(arg_0));
        this.scheduledTasks.clear();
    }

    public void cancelScheduledSnapshot(String lifecycleJobId) {
        logger.debug("cancelling snapshot lifecycle job [{}] as it no longer exists", (Object)lifecycleJobId);
        this.scheduledTasks.remove(lifecycleJobId);
        this.scheduler.remove(lifecycleJobId);
    }

    public static void validateRepositoryExists(String repository, ClusterState state) {
        if (((RepositoriesMetadata)state.metadata().custom("repositories", (Metadata.Custom)RepositoriesMetadata.EMPTY)).repository(repository) == null) {
            throw new IllegalArgumentException("no such repository [" + repository + "]");
        }
    }

    public static void validateMinimumInterval(SnapshotLifecyclePolicy lifecycle, ClusterState state) {
        TimeValue minimum = (TimeValue)LifecycleSettings.SLM_MINIMUM_INTERVAL_SETTING.get(state.metadata().settings());
        TimeValue next = lifecycle.calculateNextInterval();
        if (next.duration() > 0L && minimum.duration() > 0L && next.millis() < minimum.millis()) {
            throw new IllegalArgumentException("invalid schedule [" + lifecycle.getSchedule() + "]: schedule would be too frequent, executing more than every [" + minimum.getStringRep() + "]");
        }
    }

    @Override
    public void close() {
        if (this.running.compareAndSet(true, false)) {
            this.scheduler.stop();
        }
    }
}

