/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms.latest;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper;

public class LatestConfig
implements Writeable,
ToXContentObject {
    private static final String NAME = "latest_config";
    private static final ParseField UNIQUE_KEY = new ParseField("unique_key", new String[0]);
    private static final ParseField SORT = new ParseField("sort", new String[0]);
    private final List<String> uniqueKey;
    private final String sort;
    private static final ConstructingObjectParser<LatestConfig, Void> STRICT_PARSER = LatestConfig.createParser(false);
    private static final ConstructingObjectParser<LatestConfig, Void> LENIENT_PARSER = LatestConfig.createParser(true);

    private static ConstructingObjectParser<LatestConfig, Void> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME, lenient, args -> new LatestConfig((List)args[0], (String)args[1]));
        parser.declareStringArray(ConstructingObjectParser.constructorArg(), UNIQUE_KEY);
        parser.declareString(ConstructingObjectParser.constructorArg(), SORT);
        return parser;
    }

    public static LatestConfig fromXContent(XContentParser parser, boolean lenient) throws IOException {
        return lenient ? (LatestConfig)LENIENT_PARSER.apply(parser, null) : (LatestConfig)STRICT_PARSER.apply(parser, null);
    }

    public LatestConfig(List<String> uniqueKey, String sort) {
        this.uniqueKey = ExceptionsHelper.requireNonNull(uniqueKey, UNIQUE_KEY.getPreferredName());
        this.sort = ExceptionsHelper.requireNonNull(sort, SORT.getPreferredName());
    }

    public LatestConfig(StreamInput in) throws IOException {
        this.uniqueKey = in.readStringList();
        this.sort = in.readString();
    }

    public List<String> getUniqueKey() {
        return this.uniqueKey;
    }

    public String getSort() {
        return this.sort;
    }

    public List<SortBuilder<?>> getSorts() {
        return Collections.singletonList(SortBuilders.fieldSort((String)this.sort).order(SortOrder.DESC));
    }

    public ActionRequestValidationException validate(ActionRequestValidationException validationException) {
        if (this.uniqueKey.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"latest.unique_key must be non-empty", (ActionRequestValidationException)validationException);
        } else {
            HashSet<String> uniqueKeyElements = new HashSet<String>();
            for (int i = 0; i < this.uniqueKey.size(); ++i) {
                if (this.uniqueKey.get(i).isEmpty()) {
                    validationException = ValidateActions.addValidationError((String)("latest.unique_key[" + i + "] element must be non-empty"), (ActionRequestValidationException)validationException);
                    continue;
                }
                if (uniqueKeyElements.contains(this.uniqueKey.get(i))) {
                    validationException = ValidateActions.addValidationError((String)("latest.unique_key elements must be unique, found duplicate element [" + this.uniqueKey.get(i) + "]"), (ActionRequestValidationException)validationException);
                    continue;
                }
                uniqueKeyElements.add(this.uniqueKey.get(i));
            }
        }
        if (this.sort.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"latest.sort must be non-empty", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void checkForDeprecations(String id, NamedXContentRegistry namedXContentRegistry, Consumer<DeprecationIssue> onDeprecation) {
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(UNIQUE_KEY.getPreferredName(), this.uniqueKey);
        builder.field(SORT.getPreferredName(), this.sort);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.uniqueKey);
        out.writeString(this.sort);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        LatestConfig that = (LatestConfig)other;
        return Objects.equals(this.uniqueKey, that.uniqueKey) && Objects.equals(this.sort, that.sort);
    }

    public int hashCode() {
        return Objects.hash(this.uniqueKey, this.sort);
    }
}

