/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.slm;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.slm.SnapshotInvocationRecord;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicy;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleStats;

public class SnapshotLifecyclePolicyItem
implements ToXContentFragment,
Writeable {
    private static final ParseField SNAPSHOT_IN_PROGRESS = new ParseField("in_progress", new String[0]);
    private static final ParseField POLICY_STATS = new ParseField("stats", new String[0]);
    private final SnapshotLifecyclePolicy policy;
    private final long version;
    private final long modifiedDate;
    @Nullable
    private final SnapshotInProgress snapshotInProgress;
    private final SnapshotLifecycleStats.SnapshotPolicyStats policyStats;
    @Nullable
    private final SnapshotInvocationRecord lastSuccess;
    @Nullable
    private final SnapshotInvocationRecord lastFailure;

    public SnapshotLifecyclePolicyItem(SnapshotLifecyclePolicyMetadata policyMetadata, @Nullable SnapshotInProgress snapshotInProgress, @Nullable SnapshotLifecycleStats.SnapshotPolicyStats policyStats) {
        this.policy = policyMetadata.getPolicy();
        this.version = policyMetadata.getVersion();
        this.modifiedDate = policyMetadata.getModifiedDate();
        this.lastSuccess = policyMetadata.getLastSuccess();
        this.lastFailure = policyMetadata.getLastFailure();
        this.snapshotInProgress = snapshotInProgress;
        this.policyStats = policyStats == null ? new SnapshotLifecycleStats.SnapshotPolicyStats(this.policy.getId()) : policyStats;
    }

    public SnapshotLifecyclePolicyItem(StreamInput in) throws IOException {
        this.policy = new SnapshotLifecyclePolicy(in);
        this.version = in.readVLong();
        this.modifiedDate = in.readVLong();
        this.lastSuccess = (SnapshotInvocationRecord)in.readOptionalWriteable(SnapshotInvocationRecord::new);
        this.lastFailure = (SnapshotInvocationRecord)in.readOptionalWriteable(SnapshotInvocationRecord::new);
        this.snapshotInProgress = (SnapshotInProgress)in.readOptionalWriteable(SnapshotInProgress::new);
        this.policyStats = new SnapshotLifecycleStats.SnapshotPolicyStats(in);
    }

    SnapshotLifecyclePolicyItem(SnapshotLifecyclePolicy policy, long version, long modifiedDate, SnapshotInvocationRecord lastSuccess, SnapshotInvocationRecord lastFailure, @Nullable SnapshotInProgress snapshotInProgress, SnapshotLifecycleStats.SnapshotPolicyStats policyStats) {
        this.policy = policy;
        this.version = version;
        this.modifiedDate = modifiedDate;
        this.lastSuccess = lastSuccess;
        this.lastFailure = lastFailure;
        this.snapshotInProgress = snapshotInProgress;
        this.policyStats = policyStats;
    }

    public SnapshotLifecyclePolicy getPolicy() {
        return this.policy;
    }

    public long getVersion() {
        return this.version;
    }

    public long getModifiedDate() {
        return this.modifiedDate;
    }

    public SnapshotInvocationRecord getLastSuccess() {
        return this.lastSuccess;
    }

    public SnapshotInvocationRecord getLastFailure() {
        return this.lastFailure;
    }

    @Nullable
    public SnapshotInProgress getSnapshotInProgress() {
        return this.snapshotInProgress;
    }

    public SnapshotLifecycleStats.SnapshotPolicyStats getPolicyStats() {
        return this.policyStats;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.policy.writeTo(out);
        out.writeVLong(this.version);
        out.writeVLong(this.modifiedDate);
        out.writeOptionalWriteable((Writeable)this.lastSuccess);
        out.writeOptionalWriteable((Writeable)this.lastFailure);
        out.writeOptionalWriteable((Writeable)this.snapshotInProgress);
        this.policyStats.writeTo(out);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.policy, this.version, this.modifiedDate, this.lastSuccess, this.lastFailure, this.policyStats});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SnapshotLifecyclePolicyItem other = (SnapshotLifecyclePolicyItem)obj;
        return this.policy.equals((Object)other.policy) && this.version == other.version && this.modifiedDate == other.modifiedDate && Objects.equals((Object)this.lastSuccess, (Object)other.lastSuccess) && Objects.equals((Object)this.lastFailure, (Object)other.lastFailure) && Objects.equals(this.snapshotInProgress, other.snapshotInProgress) && Objects.equals(this.policyStats, other.policyStats);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.policy.getId());
        builder.field(SnapshotLifecyclePolicyMetadata.VERSION.getPreferredName(), this.version);
        builder.timeField(SnapshotLifecyclePolicyMetadata.MODIFIED_DATE_MILLIS.getPreferredName(), SnapshotLifecyclePolicyMetadata.MODIFIED_DATE.getPreferredName(), this.modifiedDate);
        builder.field(SnapshotLifecyclePolicyMetadata.POLICY.getPreferredName(), (ToXContent)this.policy);
        if (this.lastSuccess != null) {
            builder.field(SnapshotLifecyclePolicyMetadata.LAST_SUCCESS.getPreferredName(), (ToXContent)this.lastSuccess);
        }
        if (this.lastFailure != null) {
            builder.field(SnapshotLifecyclePolicyMetadata.LAST_FAILURE.getPreferredName(), (ToXContent)this.lastFailure);
        }
        builder.timeField(SnapshotLifecyclePolicyMetadata.NEXT_EXECUTION_MILLIS.getPreferredName(), SnapshotLifecyclePolicyMetadata.NEXT_EXECUTION.getPreferredName(), this.policy.calculateNextExecution());
        if (this.snapshotInProgress != null) {
            builder.field(SNAPSHOT_IN_PROGRESS.getPreferredName(), (ToXContent)this.snapshotInProgress);
        }
        builder.startObject(POLICY_STATS.getPreferredName());
        this.policyStats.toXContent(builder, params);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static class SnapshotInProgress
    implements ToXContentObject,
    Writeable {
        private static final ParseField NAME = new ParseField("name", new String[0]);
        private static final ParseField UUID = new ParseField("uuid", new String[0]);
        private static final ParseField STATE = new ParseField("state", new String[0]);
        private static final ParseField START_TIME = new ParseField("start_time_millis", new String[0]);
        private static final ParseField FAILURE = new ParseField("failure", new String[0]);
        private final SnapshotId snapshotId;
        private final SnapshotsInProgress.State state;
        private final long startTime;
        private final String failure;

        public SnapshotInProgress(SnapshotId snapshotId, SnapshotsInProgress.State state, long startTime, @Nullable String failure) {
            this.snapshotId = snapshotId;
            this.state = state;
            this.startTime = startTime;
            this.failure = failure;
        }

        SnapshotInProgress(StreamInput in) throws IOException {
            this.snapshotId = new SnapshotId(in);
            this.state = (SnapshotsInProgress.State)in.readEnum(SnapshotsInProgress.State.class);
            this.startTime = in.readVLong();
            this.failure = in.readOptionalString();
        }

        public static SnapshotInProgress fromEntry(SnapshotsInProgress.Entry entry) {
            return new SnapshotInProgress(entry.snapshot().getSnapshotId(), entry.state(), entry.startTime(), entry.failure());
        }

        public SnapshotId getSnapshotId() {
            return this.snapshotId;
        }

        public SnapshotsInProgress.State getState() {
            return this.state;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public String getFailure() {
            return this.failure;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.snapshotId.writeTo(out);
            out.writeEnum((Enum)this.state);
            out.writeVLong(this.startTime);
            out.writeOptionalString(this.failure);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(NAME.getPreferredName(), this.snapshotId.getName());
            builder.field(UUID.getPreferredName(), this.snapshotId.getUUID());
            builder.field(STATE.getPreferredName(), (Enum)this.state);
            builder.timeField(START_TIME.getPreferredName(), "start_time", this.startTime);
            if (this.failure != null) {
                builder.field(FAILURE.getPreferredName(), this.failure);
            }
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.snapshotId, this.state, this.startTime, this.failure);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            SnapshotInProgress other = (SnapshotInProgress)obj;
            return Objects.equals(this.snapshotId, other.snapshotId) && Objects.equals(this.state, other.state) && this.startTime == other.startTime && Objects.equals(this.failure, other.failure);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }
}

