/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.annotations;

import java.io.IOException;
import java.util.List;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthAction;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.core.template.TemplateUtils;

public class AnnotationIndex {
    private static final Logger logger = LogManager.getLogger(AnnotationIndex.class);
    public static final String READ_ALIAS_NAME = ".ml-annotations-read";
    public static final String WRITE_ALIAS_NAME = ".ml-annotations-write";
    public static final String LATEST_INDEX_NAME = ".ml-annotations-000001";
    public static final List<String> OLD_INDEX_NAMES = List.of(".ml-annotations-6");
    private static final String MAPPINGS_VERSION_VARIABLE = "xpack.ml.version";

    public static void createAnnotationsIndexIfNecessaryAndWaitForYellow(Client client, ClusterState state, TimeValue masterNodeTimeout, ActionListener<Boolean> finalListener) {
        ActionListener annotationsIndexCreatedListener = ActionListener.wrap(success -> {
            ClusterHealthRequest request = (ClusterHealthRequest)Requests.clusterHealthRequest((String[])new String[]{READ_ALIAS_NAME}).waitForYellowStatus().masterNodeTimeout(masterNodeTimeout);
            ClientHelper.executeAsyncWithOrigin(client, "ml", ClusterHealthAction.INSTANCE, request, ActionListener.wrap(r -> finalListener.onResponse((Object)(!r.isTimedOut() ? 1 : 0)), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0)));
        }, arg_0 -> finalListener.onFailure(arg_0));
        AnnotationIndex.createAnnotationsIndexIfNecessary(client, state, masterNodeTimeout, (ActionListener<Boolean>)annotationsIndexCreatedListener);
    }

    public static void createAnnotationsIndexIfNecessary(Client client, ClusterState state, TimeValue masterNodeTimeout, ActionListener<Boolean> finalListener) {
        ActionListener checkMappingsListener = ActionListener.wrap(success -> ElasticsearchMappings.addDocMappingIfMissing(WRITE_ALIAS_NAME, (CheckedSupplier<String, IOException>)((CheckedSupplier)AnnotationIndex::annotationsMapping), client, state, masterNodeTimeout, finalListener), arg_0 -> finalListener.onFailure(arg_0));
        ActionListener createAliasListener = ActionListener.wrap(success -> {
            IndicesAliasesRequestBuilder requestBuilder = client.admin().indices().prepareAliases().addAliasAction(IndicesAliasesRequest.AliasActions.add().index(LATEST_INDEX_NAME).alias(READ_ALIAS_NAME).isHidden(Boolean.valueOf(true))).addAliasAction(IndicesAliasesRequest.AliasActions.add().index(LATEST_INDEX_NAME).alias(WRITE_ALIAS_NAME).isHidden(Boolean.valueOf(true)));
            for (String oldIndexName : OLD_INDEX_NAMES) {
                if (!state.getMetadata().getIndicesLookup().containsKey(oldIndexName)) continue;
                requestBuilder.removeAlias(oldIndexName, WRITE_ALIAS_NAME);
            }
            ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", (IndicesAliasesRequest)requestBuilder.request(), ActionListener.wrap(r -> checkMappingsListener.onResponse((Object)r.isAcknowledged()), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0)), (arg_0, arg_1) -> ((IndicesAdminClient)client.admin().indices()).aliases(arg_0, arg_1));
        }, arg_0 -> finalListener.onFailure(arg_0));
        MlMetadata mlMetadata = MlMetadata.getMlMetadata(state);
        SortedMap mlLookup = state.getMetadata().getIndicesLookup().tailMap(".ml");
        if (!mlMetadata.isResetMode() && !mlMetadata.isUpgradeMode() && !mlLookup.isEmpty() && mlLookup.firstKey().startsWith(".ml")) {
            if (!mlLookup.containsKey(LATEST_INDEX_NAME)) {
                logger.debug(() -> new ParameterizedMessage("Creating [{}] because [{}] exists; trace {}", new Object[]{LATEST_INDEX_NAME, mlLookup.firstKey(), ExceptionsHelper.formatStackTrace((StackTraceElement[])Thread.currentThread().getStackTrace())}));
                CreateIndexRequest createIndexRequest = new CreateIndexRequest(LATEST_INDEX_NAME).mapping(AnnotationIndex.annotationsMapping()).settings(Settings.builder().put("index.auto_expand_replicas", "0-1").put("index.number_of_shards", "1").put("index.hidden", true));
                ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", createIndexRequest, ActionListener.wrap(r -> createAliasListener.onResponse((Object)r.isAcknowledged()), e -> {
                    if (org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.unwrapCause(e) instanceof ResourceAlreadyExistsException) {
                        createAliasListener.onResponse((Object)true);
                    } else {
                        finalListener.onFailure(e);
                    }
                }), (arg_0, arg_1) -> ((IndicesAdminClient)client.admin().indices()).create(arg_0, arg_1));
                return;
            }
            IndexAbstraction writeAliasDefinition = (IndexAbstraction)mlLookup.get(WRITE_ALIAS_NAME);
            if (!mlLookup.containsKey(READ_ALIAS_NAME) || writeAliasDefinition == null) {
                createAliasListener.onResponse((Object)true);
                return;
            }
            List writeAliasIndices = writeAliasDefinition.getIndices();
            if (writeAliasIndices.size() != 1 || !LATEST_INDEX_NAME.equals(((Index)writeAliasIndices.get(0)).getName())) {
                createAliasListener.onResponse((Object)true);
                return;
            }
            checkMappingsListener.onResponse((Object)false);
            return;
        }
        finalListener.onResponse((Object)false);
    }

    public static String annotationsMapping() {
        return TemplateUtils.loadTemplate("/org/elasticsearch/xpack/core/ml/annotations_index_mappings.json", Version.CURRENT.toString(), MAPPINGS_VERSION_VARIABLE);
    }
}

