/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class CloseJobAction
extends ActionType<Response> {
    public static final CloseJobAction INSTANCE = new CloseJobAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/close";

    private CloseJobAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends BaseTasksResponse
    implements Writeable,
    ToXContentObject {
        private final boolean closed;

        public Response(boolean closed) {
            super(null, null);
            this.closed = closed;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.closed = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.closed);
        }

        public boolean isClosed() {
            return this.closed;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("closed", this.closed);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return this.closed == response.closed;
        }

        public int hashCode() {
            return Objects.hash(this.closed);
        }
    }

    public static class Request
    extends BaseTasksRequest<Request>
    implements ToXContentObject {
        public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
        public static final ParseField FORCE = new ParseField("force", new String[0]);
        public static final ParseField ALLOW_NO_MATCH = new ParseField("allow_no_match", new String[0]).forRestApiVersion(RestApiVersion.onOrAfter((RestApiVersion)RestApiVersion.V_8));
        public static final ParseField ALLOW_NO_MATCH_V7 = new ParseField("allow_no_match", new String[]{"allow_no_jobs"}).forRestApiVersion(RestApiVersion.equalTo((RestApiVersion)RestApiVersion.V_7));
        public static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:admin/xpack/ml/job/close", Request::new);
        private String jobId;
        private boolean force = false;
        private boolean allowNoMatch = true;
        private TimeValue timeout = MachineLearningField.STATE_PERSIST_RESTORE_TIMEOUT;
        private String[] openJobIds;
        private boolean local;

        public static Request parseRequest(String jobId, XContentParser parser) {
            Request request = (Request)((Object)PARSER.apply(parser, null));
            if (jobId != null) {
                request.setJobId(jobId);
            }
            return request;
        }

        public Request() {
            this.openJobIds = new String[0];
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.jobId = in.readString();
            this.timeout = in.readTimeValue();
            this.force = in.readBoolean();
            this.openJobIds = in.readStringArray();
            this.local = in.readBoolean();
            this.allowNoMatch = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            out.writeTimeValue(this.timeout);
            out.writeBoolean(this.force);
            out.writeStringArray(this.openJobIds);
            out.writeBoolean(this.local);
            out.writeBoolean(this.allowNoMatch);
        }

        public Request(String jobId) {
            this();
            this.jobId = jobId;
        }

        public String getJobId() {
            return this.jobId;
        }

        public Request setJobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public TimeValue getCloseTimeout() {
            return this.timeout;
        }

        public Request setCloseTimeout(TimeValue timeout) {
            this.timeout = timeout;
            return this;
        }

        public boolean isForce() {
            return this.force;
        }

        public Request setForce(boolean force) {
            this.force = force;
            return this;
        }

        public boolean allowNoMatch() {
            return this.allowNoMatch;
        }

        public Request setAllowNoMatch(boolean allowNoMatch) {
            this.allowNoMatch = allowNoMatch;
            return this;
        }

        public boolean isLocal() {
            return this.local;
        }

        public Request setLocal(boolean local) {
            this.local = local;
            return this;
        }

        public String[] getOpenJobIds() {
            return this.openJobIds;
        }

        public Request setOpenJobIds(String[] openJobIds) {
            this.openJobIds = openJobIds;
            return this;
        }

        public boolean match(Task task) {
            for (String id : this.openJobIds) {
                if (!OpenJobAction.JobTaskMatcher.match(task, id)) continue;
                return true;
            }
            return false;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            builder.field(TIMEOUT.getPreferredName(), this.timeout.getStringRep());
            builder.field(FORCE.getPreferredName(), this.force);
            if (builder.getRestApiVersion() == RestApiVersion.V_7) {
                builder.field("allow_no_jobs", this.allowNoMatch);
            } else {
                builder.field(ALLOW_NO_MATCH.getPreferredName(), this.allowNoMatch);
            }
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.timeout, this.force, this.allowNoMatch);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.timeout, other.timeout) && Objects.equals(this.force, other.force) && Objects.equals(this.allowNoMatch, other.allowNoMatch);
        }

        static {
            PARSER.declareString(Request::setJobId, Job.ID);
            PARSER.declareString((request, val) -> request.setCloseTimeout(TimeValue.parseTimeValue((String)val, (String)TIMEOUT.getPreferredName())), TIMEOUT);
            PARSER.declareBoolean(Request::setForce, FORCE);
            PARSER.declareBoolean(Request::setAllowNoMatch, ALLOW_NO_MATCH);
            PARSER.declareBoolean(Request::setAllowNoMatch, ALLOW_NO_MATCH_V7);
        }
    }
}

