/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.cluster.routing.allocation;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.Strings;

public class DataTierAllocationDecider
extends AllocationDecider {
    public static final String NAME = "data_tier";

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.shouldFilter(shardRouting, node.node(), allocation);
    }

    public Decision canAllocate(IndexMetadata indexMetadata, RoutingNode node, RoutingAllocation allocation) {
        return this.shouldFilter(indexMetadata, node.node().getRoles(), allocation);
    }

    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.shouldFilter(shardRouting, node.node(), allocation);
    }

    public Decision shouldAutoExpandToNode(IndexMetadata indexMetadata, DiscoveryNode node, RoutingAllocation allocation) {
        return this.shouldFilter(indexMetadata, node.getRoles(), allocation);
    }

    private Decision shouldFilter(ShardRouting shardRouting, DiscoveryNode node, RoutingAllocation allocation) {
        return this.shouldFilter(allocation.metadata().getIndexSafe(shardRouting.index()), node.getRoles(), allocation);
    }

    public Decision shouldFilter(IndexMetadata indexMd, Set<DiscoveryNodeRole> roles, RoutingAllocation allocation) {
        return this.shouldFilter(indexMd, roles, DataTierAllocationDecider::preferredAvailableTier, allocation);
    }

    public Decision shouldFilter(IndexMetadata indexMd, Set<DiscoveryNodeRole> roles, PreferredTierFunction preferredTierFunction, RoutingAllocation allocation) {
        Decision decision = this.shouldIndexPreferTier(indexMd, roles, preferredTierFunction, allocation);
        if (decision != null) {
            return decision;
        }
        return allocation.decision(Decision.YES, NAME, "node passes tier preference filters", new Object[0]);
    }

    private Decision shouldIndexPreferTier(IndexMetadata indexMetadata, Set<DiscoveryNodeRole> roles, PreferredTierFunction preferredTierFunction, RoutingAllocation allocation) {
        List tierPreference = indexMetadata.getTierPreference();
        if (!tierPreference.isEmpty()) {
            Optional<String> tier = preferredTierFunction.apply(tierPreference, allocation.nodes());
            if (tier.isPresent()) {
                String tierName = tier.get();
                if (DataTierAllocationDecider.allocationAllowed(tierName, roles)) {
                    if (!allocation.debugDecision()) {
                        return Decision.YES;
                    }
                    return allocation.decision(Decision.YES, NAME, "index has a preference for tiers [%s] and node has tier [%s]", new Object[]{String.join((CharSequence)",", tierPreference), tierName});
                }
                if (!allocation.debugDecision()) {
                    return Decision.NO;
                }
                return allocation.decision(Decision.NO, NAME, "index has a preference for tiers [%s] and node does not meet the required [%s] tier", new Object[]{String.join((CharSequence)",", tierPreference), tierName});
            }
            if (!allocation.debugDecision()) {
                return Decision.NO;
            }
            return allocation.decision(Decision.NO, NAME, "index has a preference for tiers [%s], but no nodes for any of those tiers are available in the cluster", new Object[]{String.join((CharSequence)",", tierPreference)});
        }
        return null;
    }

    public static Optional<String> preferredAvailableTier(List<String> prioritizedTiers, DiscoveryNodes nodes) {
        for (String tier : prioritizedTiers) {
            if (!DataTierAllocationDecider.tierNodesPresent(tier, nodes)) continue;
            return Optional.of(tier);
        }
        return Optional.empty();
    }

    static boolean tierNodesPresent(String singleTier, DiscoveryNodes nodes) {
        assert (singleTier.equals(DiscoveryNodeRole.DATA_ROLE.roleName()) || DataTier.validTierName((String)singleTier)) : "tier " + singleTier + " is an invalid tier name";
        for (DiscoveryNode node : nodes.getNodes().values()) {
            for (DiscoveryNodeRole discoveryNodeRole : node.getRoles()) {
                String s = discoveryNodeRole.roleName();
                if (!s.equals(DiscoveryNodeRole.DATA_ROLE.roleName()) && !s.equals(singleTier)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean allocationAllowed(String tierName, Set<DiscoveryNodeRole> roles) {
        assert (Strings.hasText((String)tierName)) : "tierName must be not null and non-empty, but was [" + tierName + "]";
        if (roles.contains(DiscoveryNodeRole.DATA_ROLE)) {
            return true;
        }
        for (DiscoveryNodeRole role : roles) {
            if (!tierName.equals(role.roleName())) continue;
            return true;
        }
        return false;
    }

    public static interface PreferredTierFunction {
        public Optional<String> apply(List<String> var1, DiscoveryNodes var2);
    }
}

