/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.protocol.xpack.license;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.protocol.xpack.common.ProtocolUtils;
import org.elasticsearch.protocol.xpack.license.LicensesStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class PutLicenseResponse
extends AcknowledgedResponse {
    private final LicensesStatus status;
    private final Map<String, String[]> acknowledgeMessages;
    private final String acknowledgeHeader;

    public PutLicenseResponse(StreamInput in) throws IOException {
        super(in);
        this.status = LicensesStatus.fromId(in.readVInt());
        this.acknowledgeHeader = in.readOptionalString();
        int size = in.readVInt();
        HashMap<String, String[]> acknowledgeMessages = new HashMap<String, String[]>(size);
        for (int i = 0; i < size; ++i) {
            String feature = in.readString();
            int nMessages = in.readVInt();
            String[] messages = new String[nMessages];
            for (int j = 0; j < nMessages; ++j) {
                messages[j] = in.readString();
            }
            acknowledgeMessages.put(feature, messages);
        }
        this.acknowledgeMessages = acknowledgeMessages;
    }

    public PutLicenseResponse(boolean acknowledged, LicensesStatus status) {
        this(acknowledged, status, null, Collections.emptyMap());
    }

    public PutLicenseResponse(boolean acknowledged, LicensesStatus status, String acknowledgeHeader, Map<String, String[]> acknowledgeMessages) {
        super(acknowledged);
        this.status = status;
        this.acknowledgeHeader = acknowledgeHeader;
        this.acknowledgeMessages = acknowledgeMessages;
    }

    public LicensesStatus status() {
        return this.status;
    }

    public Map<String, String[]> acknowledgeMessages() {
        return this.acknowledgeMessages;
    }

    public String acknowledgeHeader() {
        return this.acknowledgeHeader;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.status.id());
        out.writeOptionalString(this.acknowledgeHeader);
        out.writeVInt(this.acknowledgeMessages.size());
        for (Map.Entry<String, String[]> entry : this.acknowledgeMessages.entrySet()) {
            out.writeString(entry.getKey());
            out.writeVInt(entry.getValue().length);
            for (String message : entry.getValue()) {
                out.writeString(message);
            }
        }
    }

    protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("license_status", this.status.toString());
        if (!this.acknowledgeMessages.isEmpty()) {
            builder.startObject("acknowledge");
            builder.field("message", this.acknowledgeHeader);
            for (Map.Entry<String, String[]> entry : this.acknowledgeMessages.entrySet()) {
                builder.startArray(entry.getKey());
                for (String message : entry.getValue()) {
                    builder.value(message);
                }
                builder.endArray();
            }
            builder.endObject();
        }
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PutLicenseResponse that = (PutLicenseResponse)((Object)o);
        return this.status == that.status && ProtocolUtils.equals(this.acknowledgeMessages, that.acknowledgeMessages) && Objects.equals(this.acknowledgeHeader, that.acknowledgeHeader);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.status, ProtocolUtils.hashCode(this.acknowledgeMessages), this.acknowledgeHeader});
    }
}

