/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.cache.common;

import org.elasticsearch.core.Nullable;

public final class ByteRange
implements Comparable<ByteRange> {
    public static final ByteRange EMPTY = new ByteRange(0L, 0L);
    private final long start;
    private final long end;

    public static ByteRange of(long start, long end) {
        return new ByteRange(start, end);
    }

    private ByteRange(long start, long end) {
        this.start = start;
        this.end = end;
        assert (start >= 0L) : "Start must be >= 0 but saw [" + start + "]";
        assert (end >= start) : "End must be greater or equal to start but saw [" + start + "][" + start + "]";
    }

    public ByteRange minEnvelope(@Nullable ByteRange other) {
        if (other == null) {
            return this;
        }
        if (other.isSubRangeOf(this)) {
            return this;
        }
        if (this.isSubRangeOf(other)) {
            return other;
        }
        return ByteRange.of(Math.min(this.start, other.start), Math.max(this.end, other.end));
    }

    public long start() {
        return this.start;
    }

    public long end() {
        return this.end;
    }

    public long length() {
        return this.end - this.start;
    }

    public boolean isSubRangeOf(ByteRange range) {
        return this.start >= range.start() && this.end <= range.end();
    }

    public boolean contains(long start, long end) {
        return this.start() <= start && end <= this.end();
    }

    public ByteRange shift(long delta) {
        if (this == EMPTY) {
            return EMPTY;
        }
        return ByteRange.of(this.start + delta, this.end + delta);
    }

    public int hashCode() {
        return 31 * Long.hashCode(this.start) + Long.hashCode(this.end);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ByteRange)) {
            return false;
        }
        ByteRange that = (ByteRange)obj;
        return this.start == that.start && this.end == that.end;
    }

    public String toString() {
        return "ByteRange [" + this.start + "-" + this.end + "]";
    }

    @Override
    public int compareTo(ByteRange o) {
        return Long.compare(this.start, o.start);
    }

    public boolean isEmpty() {
        return this.start == this.end;
    }
}

