/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions;

import java.io.IOException;
import java.time.Clock;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Map;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.routing.Preference;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.watcher.execution.ActionExecutionMode;
import org.elasticsearch.xpack.core.watcher.history.WatchRecord;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.core.watcher.transport.actions.execute.ExecuteWatchRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.execute.ExecuteWatchResponse;
import org.elasticsearch.xpack.core.watcher.trigger.TriggerEvent;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.core.watcher.watch.Watch;
import org.elasticsearch.xpack.watcher.ClockHolder;
import org.elasticsearch.xpack.watcher.condition.InternalAlwaysCondition;
import org.elasticsearch.xpack.watcher.execution.ExecutionService;
import org.elasticsearch.xpack.watcher.execution.ManualExecutionContext;
import org.elasticsearch.xpack.watcher.input.simple.SimpleInput;
import org.elasticsearch.xpack.watcher.transport.actions.WatcherTransportAction;
import org.elasticsearch.xpack.watcher.trigger.TriggerService;
import org.elasticsearch.xpack.watcher.trigger.manual.ManualTriggerEvent;
import org.elasticsearch.xpack.watcher.watch.WatchParser;

public class TransportExecuteWatchAction
extends WatcherTransportAction<ExecuteWatchRequest, ExecuteWatchResponse> {
    private final ThreadPool threadPool;
    private final ExecutionService executionService;
    private final Clock clock;
    private final TriggerService triggerService;
    private final WatchParser watchParser;
    private final Client client;

    @Inject
    public TransportExecuteWatchAction(TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, ExecutionService executionService, ClockHolder clockHolder, XPackLicenseState licenseState, WatchParser watchParser, Client client, TriggerService triggerService) {
        super("cluster:admin/xpack/watcher/watch/execute", transportService, actionFilters, licenseState, ExecuteWatchRequest::new);
        this.threadPool = threadPool;
        this.executionService = executionService;
        this.clock = clockHolder.clock;
        this.triggerService = triggerService;
        this.watchParser = watchParser;
        this.client = client;
    }

    @Override
    protected void doExecute(ExecuteWatchRequest request, ActionListener<ExecuteWatchResponse> listener) {
        if (request.getId() != null) {
            GetRequest getRequest = new GetRequest(".watches", request.getId()).preference(Preference.LOCAL.type()).realtime(true);
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"watcher", (ActionRequest)getRequest, (ActionListener)ActionListener.wrap(response -> {
                if (response.isExists()) {
                    Watch watch = this.watchParser.parse(request.getId(), true, response.getSourceAsBytesRef(), request.getXContentType(), response.getSeqNo(), response.getPrimaryTerm());
                    watch.status().version(response.getVersion());
                    this.executeWatch(request, listener, watch, true);
                } else {
                    listener.onFailure((Exception)((Object)new ResourceNotFoundException("Watch with id [{}] does not exist", new Object[]{request.getId()})));
                }
            }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1));
        } else if (request.getWatchSource() != null) {
            try {
                assert (!request.isRecordExecution());
                Watch watch = this.watchParser.parse("_inlined_", true, request.getWatchSource(), request.getXContentType(), -2L, 0L);
                this.executeWatch(request, listener, watch, false);
            }
            catch (IOException e) {
                this.logger.error((Message)new ParameterizedMessage("failed to parse [{}]", (Object)request.getId()), (Throwable)e);
                listener.onFailure((Exception)e);
            }
        } else {
            listener.onFailure((Exception)new IllegalArgumentException("no watch provided"));
        }
    }

    private void executeWatch(final ExecuteWatchRequest request, final ActionListener<ExecuteWatchResponse> listener, Watch watch, boolean knownWatch) {
        try {
            watch.status().setHeaders(ClientHelper.filterSecurityHeaders((Map)this.threadPool.getThreadContext().getHeaders()));
            String triggerType = watch.trigger().type();
            TriggerEvent triggerEvent = this.triggerService.simulateEvent(triggerType, watch.id(), request.getTriggerData());
            ManualExecutionContext.Builder ctxBuilder = ManualExecutionContext.builder(watch, knownWatch, new ManualTriggerEvent(triggerEvent.jobName(), triggerEvent), this.executionService.defaultThrottlePeriod());
            ZonedDateTime executionTime = this.clock.instant().atZone(ZoneOffset.UTC);
            ctxBuilder.executionTime(executionTime);
            for (Map.Entry entry : request.getActionModes().entrySet()) {
                ctxBuilder.actionMode((String)entry.getKey(), (ActionExecutionMode)entry.getValue());
            }
            if (request.getAlternativeInput() != null) {
                ctxBuilder.withInput(new SimpleInput.Result((Payload)new Payload.Simple(request.getAlternativeInput())));
            }
            if (request.isIgnoreCondition()) {
                ctxBuilder.withCondition(InternalAlwaysCondition.RESULT_INSTANCE);
            }
            ctxBuilder.recordExecution(request.isRecordExecution());
            final ManualExecutionContext ctx = ctxBuilder.build();
            this.threadPool.executor("watcher").execute(new ExecutionService.WatchExecutionTask(ctx, (Runnable)new AbstractRunnable(){

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }

                protected void doRun() throws Exception {
                    WatchRecord record = TransportExecuteWatchAction.this.executionService.execute(ctx);
                    XContentBuilder builder = XContentFactory.jsonBuilder();
                    record.toXContent(builder, (ToXContent.Params)WatcherParams.builder().hideSecrets(true).debug(request.isDebug()).build());
                    listener.onResponse((Object)new ExecuteWatchResponse(record.id().value(), BytesReference.bytes((XContentBuilder)builder), XContentType.JSON));
                }
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

