/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.rest.action;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.core.watcher.transport.actions.ack.AckWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.ack.AckWatchRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.ack.AckWatchResponse;
import org.elasticsearch.xpack.core.watcher.watch.WatchField;

public class RestAckWatchAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/_watcher/watch/{id}/_ack").replaces(RestRequest.Method.POST, "/_xpack/watcher/watch/{id}/_ack", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.PUT, (String)"/_watcher/watch/{id}/_ack").replaces(RestRequest.Method.PUT, "/_xpack/watcher/watch/{id}/_ack", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/_watcher/watch/{id}/_ack/{actions}").replaces(RestRequest.Method.POST, "/_xpack/watcher/watch/{id}/_ack/{actions}", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.PUT, (String)"/_watcher/watch/{id}/_ack/{actions}").replaces(RestRequest.Method.PUT, "/_xpack/watcher/watch/{id}/_ack/{actions}", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "watcher_ack_watch";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        AckWatchRequest ackWatchRequest = new AckWatchRequest(request.param("id"), new String[0]);
        String[] actions = request.paramAsStringArray("actions", null);
        if (actions != null) {
            ackWatchRequest.setActionIds(actions);
        }
        return channel -> client.execute((ActionType)AckWatchAction.INSTANCE, (ActionRequest)ackWatchRequest, (ActionListener)new RestBuilderListener<AckWatchResponse>(channel){

            public RestResponse buildResponse(AckWatchResponse response, XContentBuilder builder) throws Exception {
                return new BytesRestResponse(RestStatus.OK, builder.startObject().field(WatchField.STATUS.getPreferredName(), (ToXContent)response.getStatus(), (ToXContent.Params)WatcherParams.HIDE_SECRETS).endObject());
            }
        });
    }
}

