/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.predicate.logical;

import java.io.IOException;
import java.util.function.BiFunction;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.expression.gen.processor.FunctionalEnumBinaryProcessor;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.ql.expression.predicate.PredicateBiFunction;

public class BinaryLogicProcessor
extends FunctionalEnumBinaryProcessor<Boolean, Boolean, Boolean, BinaryLogicOperation> {
    public static final String NAME = "lb";

    public BinaryLogicProcessor(Processor left, Processor right, BinaryLogicOperation operation) {
        super(left, right, operation);
    }

    public BinaryLogicProcessor(StreamInput in) throws IOException {
        super(in, (StreamInput i) -> i.readEnum(BinaryLogicOperation.class));
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected void checkParameter(Object param) {
        if (param != null && !(param instanceof Boolean)) {
            throw new QlIllegalArgumentException("A boolean is required; received {}", param);
        }
    }

    @Override
    public Object process(Object input) {
        Object l = this.left().process(input);
        this.checkParameter(l);
        Object r = this.right().process(input);
        this.checkParameter(r);
        return this.doProcess(l, r);
    }

    public static enum BinaryLogicOperation implements PredicateBiFunction<Boolean, Boolean, Boolean>
    {
        AND((l, r) -> {
            if (Boolean.FALSE.equals(l) || Boolean.FALSE.equals(r)) {
                return Boolean.FALSE;
            }
            if (l == null || r == null) {
                return null;
            }
            return Boolean.logicalAnd(l, r);
        }, "AND"),
        OR((l, r) -> {
            if (Boolean.TRUE.equals(l) || Boolean.TRUE.equals(r)) {
                return Boolean.TRUE;
            }
            if (l == null || r == null) {
                return null;
            }
            return Boolean.logicalOr(l, r);
        }, "OR");

        private final BiFunction<Boolean, Boolean, Boolean> process;
        private final String symbol;

        private BinaryLogicOperation(BiFunction<Boolean, Boolean, Boolean> process, String symbol) {
            this.process = process;
            this.symbol = symbol;
        }

        @Override
        public String symbol() {
            return this.symbol;
        }

        @Override
        public Boolean apply(Boolean left, Boolean right) {
            return this.process.apply(left, right);
        }

        @Override
        public final Boolean doApply(Boolean left, Boolean right) {
            return null;
        }

        public String toString() {
            return this.symbol;
        }
    }
}

