/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.predicate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.predicate.BinaryPredicate;
import org.elasticsearch.xpack.ql.expression.predicate.PredicateBiFunction;
import org.elasticsearch.xpack.ql.tree.Source;

public abstract class BinaryOperator<T, U, R, F extends PredicateBiFunction<T, U, R>>
extends BinaryPredicate<T, U, R, F> {
    protected BinaryOperator(Source source, Expression left, Expression right, F function) {
        super(source, left, right, function);
    }

    protected abstract Expression.TypeResolution resolveInputType(Expression var1, TypeResolutions.ParamOrdinal var2);

    public abstract BinaryOperator<T, U, R, F> swapLeftAndRight();

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = this.resolveInputType(this.left(), TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        return this.resolveInputType(this.right(), TypeResolutions.ParamOrdinal.SECOND);
    }

    protected boolean isCommutative() {
        return false;
    }

    @Override
    protected Expression canonicalize() {
        if (!this.isCommutative()) {
            BinaryOperator<T, U, R, F> exp = this.left().semanticHash() > this.right().semanticHash() ? this.swapLeftAndRight() : this;
            return exp != this ? exp.canonical() : super.canonicalize();
        }
        ArrayList<Expression> commutativeChildren = new ArrayList<Expression>(2);
        this.collectCommutative(commutativeChildren, this);
        commutativeChildren.sort((l, r) -> Integer.compare(l.semanticHash(), r.semanticHash()));
        while (commutativeChildren.size() > 1) {
            for (int i = 0; i < commutativeChildren.size() - 1; ++i) {
                Expression current = (Expression)commutativeChildren.get(i);
                Expression next = (Expression)commutativeChildren.remove(i + 1);
                commutativeChildren.set(i, this.replaceChildren(current, next));
            }
        }
        Iterator iterator = commutativeChildren.iterator();
        Expression last = (Expression)iterator.next();
        while (iterator.hasNext()) {
            last = this.replaceChildren(last, (Expression)iterator.next());
        }
        return last;
    }

    protected void collectCommutative(List<Expression> commutative, Expression expression) {
        if (this.getClass() == expression.getClass()) {
            BinaryOperator bi = (BinaryOperator)expression;
            this.collectCommutative(commutative, bi.left());
            this.collectCommutative(commutative, bi.right());
        } else {
            commutative.add(expression.canonical());
        }
    }
}

