/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.gen.pipeline;

import java.util.Objects;
import org.elasticsearch.xpack.ql.execution.search.AggRef;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.CommonNonExecutableInput;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class AggPathInput
extends CommonNonExecutableInput<AggRef> {
    private final Processor action;

    public AggPathInput(Expression expression, AggRef context) {
        this(Source.EMPTY, expression, context, null);
    }

    public AggPathInput(Source source, Expression expression, AggRef context, Processor action) {
        super(source, expression, context);
        this.action = action;
    }

    @Override
    protected NodeInfo<AggPathInput> info() {
        return NodeInfo.create(this, AggPathInput::new, this.expression(), (AggRef)this.context(), this.action);
    }

    public Processor action() {
        return this.action;
    }

    @Override
    public boolean resolved() {
        return true;
    }

    @Override
    public final boolean supportedByAggsOnlyQuery() {
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.context(), this.action);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AggPathInput other = (AggPathInput)obj;
        return Objects.equals(this.context(), other.context()) && Objects.equals(this.action, other.action);
    }
}

