/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms.pivot;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.transform.transforms.pivot.ScriptConfig;
import org.elasticsearch.xpack.core.transform.transforms.pivot.SingleGroupSource;

public class HistogramGroupSource
extends SingleGroupSource {
    static final ParseField INTERVAL = new ParseField("interval", new String[0]);
    private static final String NAME = "data_frame_histogram_group";
    private static final ConstructingObjectParser<HistogramGroupSource, Void> STRICT_PARSER = HistogramGroupSource.createParser(false);
    private static final ConstructingObjectParser<HistogramGroupSource, Void> LENIENT_PARSER = HistogramGroupSource.createParser(true);
    private final double interval;

    public HistogramGroupSource(String field, ScriptConfig scriptConfig, boolean missingBucket, double interval) {
        super(field, scriptConfig, missingBucket);
        if (interval <= 0.0) {
            throw new IllegalArgumentException("[interval] must be greater than 0.");
        }
        this.interval = interval;
    }

    public HistogramGroupSource(StreamInput in) throws IOException {
        super(in);
        this.interval = in.readDouble();
    }

    private static ConstructingObjectParser<HistogramGroupSource, Void> createParser(boolean lenient) {
        ConstructingObjectParser<HistogramGroupSource, Void> parser = new ConstructingObjectParser<HistogramGroupSource, Void>(NAME, lenient, args -> {
            String field = (String)args[0];
            ScriptConfig scriptConfig = (ScriptConfig)args[1];
            boolean missingBucket = args[2] == null ? false : (Boolean)args[2];
            double interval = (Double)args[3];
            return new HistogramGroupSource(field, scriptConfig, missingBucket, interval);
        });
        HistogramGroupSource.declareValuesSourceFields(parser, lenient);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), INTERVAL);
        return parser;
    }

    @Override
    public SingleGroupSource.Type getType() {
        return SingleGroupSource.Type.HISTOGRAM;
    }

    public static HistogramGroupSource fromXContent(XContentParser parser, boolean lenient) throws IOException {
        return lenient ? LENIENT_PARSER.apply(parser, null) : STRICT_PARSER.apply(parser, null);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeDouble(this.interval);
    }

    public double getInterval() {
        return this.interval;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        super.innerXContent(builder, params);
        builder.field(INTERVAL.getPreferredName(), this.interval);
        builder.endObject();
        return builder;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HistogramGroupSource that = (HistogramGroupSource)other;
        return this.missingBucket == that.missingBucket && Objects.equals(this.field, that.field) && Objects.equals(this.scriptConfig, that.scriptConfig) && Objects.equals(this.interval, that.interval);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.scriptConfig, this.interval);
    }
}

