/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class TransformDestIndexSettings
extends AbstractDiffable<TransformDestIndexSettings>
implements Writeable,
ToXContentObject {
    public static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
    public static final ParseField SETTINGS = new ParseField("settings", new String[0]);
    public static final ParseField ALIASES = new ParseField("aliases", new String[0]);
    private static final ConstructingObjectParser<TransformDestIndexSettings, Void> STRICT_PARSER = TransformDestIndexSettings.createParser(false);
    private final Map<String, Object> mappings;
    private final Settings settings;
    private final Set<Alias> aliases;

    private static ConstructingObjectParser<TransformDestIndexSettings, Void> createParser(boolean lenient) {
        ConstructingObjectParser<TransformDestIndexSettings, Void> PARSER = new ConstructingObjectParser<TransformDestIndexSettings, Void>("transform_preview_generated_dest_index", lenient, args -> {
            Map mappings = (Map)args[0];
            Settings settings = (Settings)args[1];
            Set aliases = (Set)args[2];
            return new TransformDestIndexSettings(mappings, settings, aliases);
        });
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapOrdered(), MAPPINGS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Settings.fromXContent(p), SETTINGS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            HashSet<Alias> aliases = new HashSet<Alias>();
            while (p.nextToken() != XContentParser.Token.END_OBJECT) {
                aliases.add(Alias.fromXContent(p));
            }
            return aliases;
        }, ALIASES);
        return PARSER;
    }

    public TransformDestIndexSettings(Map<String, Object> mappings, Settings settings, Set<Alias> aliases) {
        this.mappings = mappings == null ? Collections.emptyMap() : Collections.unmodifiableMap(mappings);
        this.settings = settings == null ? Settings.EMPTY : settings;
        this.aliases = aliases == null ? Collections.emptySet() : Collections.unmodifiableSet(aliases);
    }

    public TransformDestIndexSettings(StreamInput in) throws IOException {
        this.mappings = in.readMap();
        this.settings = Settings.readSettingsFromStream(in);
        this.aliases = new HashSet<Alias>(in.readList(Alias::new));
    }

    public Map<String, Object> getMappings() {
        return this.mappings;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Set<Alias> getAliases() {
        return this.aliases;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MAPPINGS.getPreferredName(), this.mappings);
        builder.startObject(SETTINGS.getPreferredName());
        this.settings.toXContent(builder, params);
        builder.endObject();
        builder.startObject(ALIASES.getPreferredName());
        for (Alias alias : this.aliases) {
            alias.toXContent(builder, params);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static TransformDestIndexSettings fromXContent(XContentParser parser) {
        return STRICT_PARSER.apply(parser, null);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.mappings);
        Settings.writeSettingsToStream(this.settings, out);
        out.writeCollection(this.aliases);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TransformDestIndexSettings other = (TransformDestIndexSettings)obj;
        return Objects.equals(other.mappings, this.mappings) && Objects.equals(other.settings, this.settings) && Objects.equals(other.aliases, this.aliases);
    }

    public int hashCode() {
        return Objects.hash(this.mappings, this.settings, this.aliases);
    }
}

