/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.license.RemoteClusterLicenseChecker;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.core.transform.transforms.QueryConfig;
import org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper;

public class SourceConfig
implements Writeable,
ToXContentObject {
    public static final ParseField QUERY = new ParseField("query", new String[0]);
    public static final ParseField INDEX = new ParseField("index", new String[0]);
    public static final ConstructingObjectParser<SourceConfig, Void> STRICT_PARSER = SourceConfig.createParser(false);
    public static final ConstructingObjectParser<SourceConfig, Void> LENIENT_PARSER = SourceConfig.createParser(true);
    private final String[] index;
    private final QueryConfig queryConfig;
    private final Map<String, Object> runtimeMappings;

    private static ConstructingObjectParser<SourceConfig, Void> createParser(boolean lenient) {
        ConstructingObjectParser<SourceConfig, Void> parser = new ConstructingObjectParser<SourceConfig, Void>("data_frame_config_source", lenient, args -> {
            String[] index = ((List)args[0]).toArray(new String[0]);
            QueryConfig queryConfig = args[1] == null ? QueryConfig.matchAll() : (QueryConfig)args[1];
            Map runtimeMappings = args[2] == null ? Collections.emptyMap() : (Map)args[2];
            return new SourceConfig(index, queryConfig, runtimeMappings);
        });
        parser.declareStringArray(ConstructingObjectParser.constructorArg(), INDEX);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> QueryConfig.fromXContent(p, lenient), QUERY);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), SearchSourceBuilder.RUNTIME_MAPPINGS_FIELD);
        return parser;
    }

    public SourceConfig(String ... index) {
        this(index, QueryConfig.matchAll(), Collections.emptyMap());
    }

    public SourceConfig(String[] index, QueryConfig queryConfig, Map<String, Object> runtimeMappings) {
        ExceptionsHelper.requireNonNull(index, INDEX.getPreferredName());
        if (index.length == 0) {
            throw new IllegalArgumentException("must specify at least one index");
        }
        if (Arrays.stream(index).anyMatch(Strings::isNullOrEmpty)) {
            throw new IllegalArgumentException("all indices need to be non-null and non-empty");
        }
        this.index = index;
        this.queryConfig = ExceptionsHelper.requireNonNull(queryConfig, QUERY.getPreferredName());
        this.runtimeMappings = Collections.unmodifiableMap(ExceptionsHelper.requireNonNull(runtimeMappings, SearchSourceBuilder.RUNTIME_MAPPINGS_FIELD.getPreferredName()));
    }

    public SourceConfig(StreamInput in) throws IOException {
        this.index = in.readStringArray();
        this.queryConfig = new QueryConfig(in);
        this.runtimeMappings = in.getVersion().onOrAfter(Version.V_7_12_0) ? in.readMap() : Collections.emptyMap();
    }

    public String[] getIndex() {
        return this.index;
    }

    public QueryConfig getQueryConfig() {
        return this.queryConfig;
    }

    public Map<String, Object> getRuntimeMappings() {
        return this.runtimeMappings;
    }

    public Map<String, Object> getScriptBasedRuntimeMappings() {
        return this.getRuntimeMappings().entrySet().stream().filter(e -> e.getValue() instanceof Map && ((Map)e.getValue()).containsKey("script")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public ActionRequestValidationException validate(ActionRequestValidationException validationException) {
        return this.queryConfig.validate(validationException);
    }

    public void checkForDeprecations(String id, NamedXContentRegistry namedXContentRegistry, Consumer<DeprecationIssue> onDeprecation) {
        this.queryConfig.checkForDeprecations(id, namedXContentRegistry, onDeprecation);
    }

    public boolean requiresRemoteCluster() {
        return Arrays.stream(this.index).anyMatch(RemoteClusterLicenseChecker::isRemoteIndex);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringArray(this.index);
        this.queryConfig.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_7_12_0)) {
            out.writeMap(this.runtimeMappings);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.array(INDEX.getPreferredName(), this.index);
        if (!params.paramAsBoolean("exclude_generated", false)) {
            builder.field(QUERY.getPreferredName(), this.queryConfig);
        } else if (!this.queryConfig.equals(QueryConfig.matchAll())) {
            builder.field(QUERY.getPreferredName(), this.queryConfig);
        }
        if (!this.runtimeMappings.isEmpty()) {
            builder.field(SearchSourceBuilder.RUNTIME_MAPPINGS_FIELD.getPreferredName(), this.runtimeMappings);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        SourceConfig that = (SourceConfig)other;
        return Arrays.equals(this.index, that.index) && Objects.equals(this.queryConfig, that.queryConfig) && Objects.equals(this.runtimeMappings, that.runtimeMappings);
    }

    public int hashCode() {
        int indexArrayHash = Arrays.hashCode(this.index);
        return Objects.hash(indexArrayHash, this.queryConfig, this.runtimeMappings);
    }

    public static SourceConfig fromXContent(XContentParser parser, boolean lenient) throws IOException {
        return lenient ? LENIENT_PARSER.apply(parser, null) : STRICT_PARSER.apply(parser, null);
    }
}

