/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.termsenum.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class TermCount
implements Writeable,
ToXContentFragment {
    public static final String TERM_FIELD = "term";
    public static final String DOC_COUNT_FIELD = "doc_count";
    static final ConstructingObjectParser<TermCount, Void> PARSER = new ConstructingObjectParser("term_count", true, a -> new TermCount((String)a[0], (Long)a[1]));
    private final String term;
    private long docCount;

    public TermCount(StreamInput in) throws IOException {
        this.term = in.readString();
        this.docCount = in.readLong();
    }

    public TermCount(String term, long count) {
        this.term = term;
        this.docCount = count;
    }

    public String getTerm() {
        return this.term;
    }

    public long getDocCount() {
        return this.docCount;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.term);
        out.writeLong(this.docCount);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(TERM_FIELD, this.getTerm());
        builder.field(DOC_COUNT_FIELD, this.getDocCount());
        return builder;
    }

    public static TermCount fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermCount other = (TermCount)o;
        return Objects.equals(this.getTerm(), other.getTerm()) && Objects.equals(this.getDocCount(), other.getDocCount());
    }

    public int hashCode() {
        return Objects.hash(this.getTerm(), this.getDocCount());
    }

    void addToDocCount(long extra) {
        this.docCount += extra;
    }

    public String toString() {
        return this.term + ":" + this.docCount;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(TERM_FIELD, new String[0]));
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField(DOC_COUNT_FIELD, new String[0]));
    }
}

