/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.X509ExtendedTrustManager;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.SslTrustConfig;
import org.elasticsearch.common.ssl.StoredCertificate;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.xpack.core.ssl.CertificateTrustRestrictions;
import org.elasticsearch.xpack.core.ssl.RestrictedTrustManager;

public final class RestrictedTrustConfig
implements SslTrustConfig {
    private static final String RESTRICTIONS_KEY_SUBJECT_NAME = "trust.subject_name";
    private final Path groupConfigPath;
    private final SslTrustConfig delegate;

    RestrictedTrustConfig(Path groupConfigPath, SslTrustConfig delegate) {
        this.groupConfigPath = Objects.requireNonNull(groupConfigPath);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public RestrictedTrustManager createTrustManager() {
        try {
            X509ExtendedTrustManager delegateTrustManager = this.delegate.createTrustManager();
            CertificateTrustRestrictions trustGroupConfig = this.readTrustGroup(this.groupConfigPath);
            return new RestrictedTrustManager(delegateTrustManager, trustGroupConfig);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to initialize TrustManager for {}", (Throwable)e, this.toString());
        }
    }

    @Override
    public Collection<? extends StoredCertificate> getConfiguredCertificates() {
        return this.delegate.getConfiguredCertificates();
    }

    @Override
    public Collection<Path> getDependentFiles() {
        return CollectionUtils.appendToCopy(this.delegate.getDependentFiles(), this.groupConfigPath);
    }

    public String toString() {
        return "restrictedTrust=[" + this.groupConfigPath + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestrictedTrustConfig that = (RestrictedTrustConfig)o;
        return this.groupConfigPath.equals(that.groupConfigPath) && this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        int result = this.groupConfigPath.hashCode();
        result = 31 * result + this.delegate.hashCode();
        return result;
    }

    private CertificateTrustRestrictions readTrustGroup(Path path) throws IOException {
        Settings settings = Settings.builder().loadFromPath(path).build();
        List<String> trustNodeNames = settings.getAsList(RESTRICTIONS_KEY_SUBJECT_NAME);
        return new CertificateTrustRestrictions(trustNodeNames);
    }
}

