/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.utils;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.template.put.PutComposableIndexTemplateAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;

public final class MlIndexAndAlias {
    private static final Logger logger = LogManager.getLogger(MlIndexAndAlias.class);
    static final Comparator<String> INDEX_NAME_COMPARATOR = new Comparator<String>(){
        private final Predicate<String> HAS_SIX_DIGIT_SUFFIX = Pattern.compile("\\d{6}").asMatchPredicate();

        @Override
        public int compare(String index1, String index2) {
            String[] index1Parts = index1.split("-");
            String index1Suffix = index1Parts[index1Parts.length - 1];
            boolean index1HasSixDigitsSuffix = this.HAS_SIX_DIGIT_SUFFIX.test(index1Suffix);
            String[] index2Parts = index2.split("-");
            String index2Suffix = index2Parts[index2Parts.length - 1];
            boolean index2HasSixDigitsSuffix = this.HAS_SIX_DIGIT_SUFFIX.test(index2Suffix);
            if (index1HasSixDigitsSuffix && index2HasSixDigitsSuffix) {
                return index1Suffix.compareTo(index2Suffix);
            }
            if (index1HasSixDigitsSuffix != index2HasSixDigitsSuffix) {
                return Boolean.compare(index1HasSixDigitsSuffix, index2HasSixDigitsSuffix);
            }
            return index1.compareTo(index2);
        }
    };

    private MlIndexAndAlias() {
    }

    public static void createIndexAndAliasIfNecessary(Client client, ClusterState clusterState, IndexNameExpressionResolver resolver, String indexPatternPrefix, String alias, TimeValue masterNodeTimeout, ActionListener<Boolean> finalListener) {
        Optional indexPointedByCurrentWriteAlias;
        ActionListener<Boolean> loggingListener = ActionListener.wrap(finalListener::onResponse, e -> {
            logger.error(new ParameterizedMessage("Failed to create alias and index with pattern [{}] and alias [{}]", (Object)indexPatternPrefix, (Object)alias), (Throwable)e);
            finalListener.onFailure((Exception)e);
        });
        ActionListener<Boolean> indexCreatedListener = ActionListener.wrap(created -> {
            if (created.booleanValue()) {
                MlIndexAndAlias.waitForShardsReady(client, alias, masterNodeTimeout, loggingListener);
            } else {
                loggingListener.onResponse(false);
            }
        }, loggingListener::onFailure);
        String legacyIndexWithoutSuffix = indexPatternPrefix;
        String indexPattern = indexPatternPrefix + "*";
        String firstConcreteIndex = indexPatternPrefix + "-000001";
        String[] concreteIndexNames = resolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandHidden(), indexPattern);
        Optional<Object> optional = indexPointedByCurrentWriteAlias = clusterState.getMetadata().hasAlias(alias) ? ((IndexAbstraction)clusterState.getMetadata().getIndicesLookup().get(alias)).getIndices().stream().map(Index::getName).findFirst() : Optional.empty();
        if (concreteIndexNames.length == 0) {
            if (indexPointedByCurrentWriteAlias.isEmpty()) {
                MlIndexAndAlias.createFirstConcreteIndex(client, firstConcreteIndex, alias, true, indexCreatedListener);
                return;
            }
            logger.error("There are no indices matching '{}' pattern but '{}' alias points at [{}]. This should never happen.", (Object)indexPattern, (Object)alias, indexPointedByCurrentWriteAlias.get());
        } else if (concreteIndexNames.length == 1 && concreteIndexNames[0].equals(legacyIndexWithoutSuffix)) {
            if (indexPointedByCurrentWriteAlias.isEmpty()) {
                MlIndexAndAlias.createFirstConcreteIndex(client, firstConcreteIndex, alias, true, indexCreatedListener);
                return;
            }
            if (((String)indexPointedByCurrentWriteAlias.get()).equals(legacyIndexWithoutSuffix)) {
                MlIndexAndAlias.createFirstConcreteIndex(client, firstConcreteIndex, alias, false, ActionListener.wrap(unused -> MlIndexAndAlias.updateWriteAlias(client, alias, legacyIndexWithoutSuffix, firstConcreteIndex, indexCreatedListener), loggingListener::onFailure));
                return;
            }
            logger.error("There is exactly one index (i.e. '{}') matching '{}' pattern but '{}' alias points at [{}]. This should never happen.", (Object)legacyIndexWithoutSuffix, (Object)indexPattern, (Object)alias, indexPointedByCurrentWriteAlias.get());
        } else if (indexPointedByCurrentWriteAlias.isEmpty()) {
            assert (concreteIndexNames.length > 0);
            String latestConcreteIndexName = Arrays.stream(concreteIndexNames).max(INDEX_NAME_COMPARATOR).get();
            MlIndexAndAlias.updateWriteAlias(client, alias, null, latestConcreteIndexName, loggingListener);
            return;
        }
        loggingListener.onResponse(false);
    }

    public static void createSystemIndexIfNecessary(Client client, ClusterState clusterState, SystemIndexDescriptor descriptor, TimeValue masterNodeTimeout, ActionListener<Boolean> finalListener) {
        String primaryIndex = descriptor.getPrimaryIndex();
        if (MlIndexAndAlias.hasIndex(clusterState, primaryIndex)) {
            finalListener.onResponse(true);
            return;
        }
        ActionListener<Boolean> indexCreatedListener = ActionListener.wrap(created -> {
            if (created.booleanValue()) {
                MlIndexAndAlias.waitForShardsReady(client, primaryIndex, masterNodeTimeout, finalListener);
            } else {
                finalListener.onResponse(false);
            }
        }, e -> {
            if (ExceptionsHelper.unwrapCause(e) instanceof ResourceAlreadyExistsException) {
                finalListener.onResponse(true);
            } else {
                finalListener.onFailure((Exception)e);
            }
        });
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(primaryIndex);
        createIndexRequest.settings(descriptor.getSettings());
        createIndexRequest.mapping(descriptor.getMappings());
        createIndexRequest.origin("ml");
        createIndexRequest.masterNodeTimeout(masterNodeTimeout);
        ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", createIndexRequest, ActionListener.wrap(r -> indexCreatedListener.onResponse(r.isAcknowledged()), indexCreatedListener::onFailure), client.admin().indices()::create);
    }

    private static void waitForShardsReady(Client client, String index, TimeValue masterNodeTimeout, ActionListener<Boolean> listener) {
        ClusterHealthRequest healthRequest = (ClusterHealthRequest)Requests.clusterHealthRequest(index).waitForYellowStatus().waitForNoRelocatingShards(true).waitForNoInitializingShards(true).masterNodeTimeout(masterNodeTimeout);
        ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", healthRequest, ActionListener.wrap(response -> listener.onResponse(!response.isTimedOut()), listener::onFailure), client.admin().cluster()::health);
    }

    private static void createFirstConcreteIndex(Client client, String index, String alias, boolean addAlias, ActionListener<Boolean> listener) {
        logger.info("About to create first concrete index [{}] with alias [{}]", (Object)index, (Object)alias);
        CreateIndexRequestBuilder requestBuilder = client.admin().indices().prepareCreate(index);
        if (addAlias) {
            requestBuilder.addAlias(new Alias(alias).isHidden(true));
        }
        CreateIndexRequest request = (CreateIndexRequest)requestBuilder.request();
        ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", request, ActionListener.wrap(createIndexResponse -> listener.onResponse(true), createIndexFailure -> {
            if (ExceptionsHelper.unwrapCause(createIndexFailure) instanceof ResourceAlreadyExistsException) {
                if (addAlias) {
                    MlIndexAndAlias.updateWriteAlias(client, alias, null, index, listener);
                } else {
                    listener.onResponse(true);
                }
            } else {
                listener.onFailure((Exception)createIndexFailure);
            }
        }), client.admin().indices()::create);
    }

    private static void updateWriteAlias(Client client, String alias, @Nullable String currentIndex, String newIndex, ActionListener<Boolean> listener) {
        logger.info("About to move write alias [{}] from index [{}] to index [{}]", (Object)alias, (Object)currentIndex, (Object)newIndex);
        IndicesAliasesRequestBuilder requestBuilder = client.admin().indices().prepareAliases().addAliasAction(IndicesAliasesRequest.AliasActions.add().index(newIndex).alias(alias).isHidden(true));
        if (currentIndex != null) {
            requestBuilder.removeAlias(currentIndex, alias);
        }
        IndicesAliasesRequest request = (IndicesAliasesRequest)requestBuilder.request();
        ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", request, ActionListener.wrap(resp -> listener.onResponse(resp.isAcknowledged()), listener::onFailure), client.admin().indices()::aliases);
    }

    public static void installIndexTemplateIfRequired(ClusterState clusterState, Client client, IndexTemplateConfig templateConfig, TimeValue masterTimeout, ActionListener<Boolean> listener) {
        PutComposableIndexTemplateAction.Request request;
        String templateName = templateConfig.getTemplateName();
        if (MlIndexAndAlias.hasIndexTemplate(clusterState, templateName)) {
            listener.onResponse(true);
            return;
        }
        try {
            request = (PutComposableIndexTemplateAction.Request)new PutComposableIndexTemplateAction.Request(templateConfig.getTemplateName()).indexTemplate(ComposableIndexTemplate.parse(JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, templateConfig.loadBytes()))).masterNodeTimeout(masterTimeout);
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("unable to parse composable template " + templateConfig.getTemplateName(), (Throwable)e, new Object[0]);
        }
        MlIndexAndAlias.installIndexTemplateIfRequired(clusterState, client, request, listener);
    }

    public static void installIndexTemplateIfRequired(ClusterState clusterState, Client client, PutComposableIndexTemplateAction.Request templateRequest, ActionListener<Boolean> listener) {
        if (MlIndexAndAlias.hasIndexTemplate(clusterState, templateRequest.name())) {
            listener.onResponse(true);
            return;
        }
        ActionListener<AcknowledgedResponse> innerListener = ActionListener.wrap(response -> {
            if (!response.isAcknowledged()) {
                logger.warn("error adding template [{}], request was not acknowledged", (Object)templateRequest.name());
            }
            listener.onResponse(response.isAcknowledged());
        }, listener::onFailure);
        ClientHelper.executeAsyncWithOrigin(client, "ml", PutComposableIndexTemplateAction.INSTANCE, templateRequest, innerListener);
    }

    public static boolean hasIndexTemplate(ClusterState state, String templateName) {
        return state.getMetadata().templatesV2().containsKey(templateName);
    }

    public static boolean hasIndex(ClusterState state, String index) {
        return state.getMetadata().getIndicesLookup().containsKey(index);
    }
}

