/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel.tree;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.job.config.Operator;

public class TreeNode
implements ToXContentObject,
Writeable,
Accountable {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(TreeNode.class);
    public static final String NAME = "tree_node";
    public static final ParseField DECISION_TYPE = new ParseField("decision_type", new String[0]);
    public static final ParseField THRESHOLD = new ParseField("threshold", new String[0]);
    public static final ParseField LEFT_CHILD = new ParseField("left_child", new String[0]);
    public static final ParseField RIGHT_CHILD = new ParseField("right_child", new String[0]);
    public static final ParseField DEFAULT_LEFT = new ParseField("default_left", new String[0]);
    public static final ParseField SPLIT_FEATURE = new ParseField("split_feature", new String[0]);
    public static final ParseField NODE_INDEX = new ParseField("node_index", new String[0]);
    public static final ParseField SPLIT_GAIN = new ParseField("split_gain", new String[0]);
    public static final ParseField LEAF_VALUE = new ParseField("leaf_value", new String[0]);
    public static final ParseField NUMBER_SAMPLES = new ParseField("number_samples", new String[0]);
    private static final ObjectParser<Builder, Void> LENIENT_PARSER = TreeNode.createParser(true);
    private static final ObjectParser<Builder, Void> STRICT_PARSER = TreeNode.createParser(false);
    private final Operator operator;
    private final double threshold;
    private final int splitFeature;
    private final int nodeIndex;
    private final double splitGain;
    private final double[] leafValue;
    private final boolean defaultLeft;
    private final int leftChild;
    private final int rightChild;
    private final long numberSamples;

    private static ObjectParser<Builder, Void> createParser(boolean lenient) {
        ObjectParser<Builder, Void> parser = new ObjectParser<Builder, Void>(NAME, lenient, () -> new Builder());
        parser.declareDouble(Builder::setThreshold, THRESHOLD);
        parser.declareField(Builder::setOperator, p -> Operator.fromString(p.text()), DECISION_TYPE, ObjectParser.ValueType.STRING);
        parser.declareInt(Builder::setLeftChild, LEFT_CHILD);
        parser.declareInt(Builder::setRightChild, RIGHT_CHILD);
        parser.declareBoolean(Builder::setDefaultLeft, DEFAULT_LEFT);
        parser.declareInt(Builder::setSplitFeature, SPLIT_FEATURE);
        parser.declareInt(Builder::setNodeIndex, NODE_INDEX);
        parser.declareDouble(Builder::setSplitGain, SPLIT_GAIN);
        parser.declareDoubleArray(Builder::setLeafValue, LEAF_VALUE);
        parser.declareLong(Builder::setNumberSamples, NUMBER_SAMPLES);
        return parser;
    }

    public static Builder fromXContent(XContentParser parser, boolean lenient) {
        return lenient ? LENIENT_PARSER.apply(parser, null) : STRICT_PARSER.apply(parser, null);
    }

    private TreeNode(Operator operator, Double threshold, Integer splitFeature, int nodeIndex, Double splitGain, List<Double> leafValue, Boolean defaultLeft, Integer leftChild, Integer rightChild, long numberSamples) {
        this.operator = operator == null ? Operator.LTE : operator;
        this.threshold = threshold == null ? Double.NaN : threshold;
        this.splitFeature = splitFeature == null ? -1 : splitFeature;
        this.nodeIndex = nodeIndex;
        this.splitGain = splitGain == null ? Double.NaN : splitGain;
        this.leafValue = leafValue == null ? new double[]{} : leafValue.stream().mapToDouble(Double::doubleValue).toArray();
        this.defaultLeft = defaultLeft == null ? false : defaultLeft;
        this.leftChild = leftChild == null ? -1 : leftChild;
        int n = this.rightChild = rightChild == null ? -1 : rightChild;
        if (numberSamples < 0L) {
            throw new IllegalArgumentException("[" + NUMBER_SAMPLES.getPreferredName() + "] must be greater than or equal to 0");
        }
        this.numberSamples = numberSamples;
    }

    public TreeNode(StreamInput in) throws IOException {
        this.operator = Operator.readFromStream(in);
        this.threshold = in.readDouble();
        this.splitFeature = in.readInt();
        this.splitGain = in.readDouble();
        this.nodeIndex = in.readVInt();
        this.leafValue = in.readDoubleArray();
        this.defaultLeft = in.readBoolean();
        this.leftChild = in.readInt();
        this.rightChild = in.readInt();
        this.numberSamples = in.readVLong();
    }

    public Operator getOperator() {
        return this.operator;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public int getSplitFeature() {
        return this.splitFeature;
    }

    public int getNodeIndex() {
        return this.nodeIndex;
    }

    public double getSplitGain() {
        return this.splitGain;
    }

    public double[] getLeafValue() {
        return this.leafValue;
    }

    public boolean isDefaultLeft() {
        return this.defaultLeft;
    }

    public int getLeftChild() {
        return this.leftChild;
    }

    public int getRightChild() {
        return this.rightChild;
    }

    public boolean isLeaf() {
        return this.leftChild < 0;
    }

    public long getNumberSamples() {
        return this.numberSamples;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.operator.writeTo(out);
        out.writeDouble(this.threshold);
        out.writeInt(this.splitFeature);
        out.writeDouble(this.splitGain);
        out.writeVInt(this.nodeIndex);
        out.writeDoubleArray(this.leafValue);
        out.writeBoolean(this.defaultLeft);
        out.writeInt(this.leftChild);
        out.writeInt(this.rightChild);
        out.writeVLong(this.numberSamples);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DECISION_TYPE.getPreferredName(), this.operator);
        this.addOptionalDouble(builder, THRESHOLD, this.threshold);
        if (this.splitFeature > -1) {
            builder.field(SPLIT_FEATURE.getPreferredName(), this.splitFeature);
        }
        this.addOptionalDouble(builder, SPLIT_GAIN, this.splitGain);
        builder.field(NODE_INDEX.getPreferredName(), this.nodeIndex);
        if (this.leafValue.length > 0) {
            builder.field(LEAF_VALUE.getPreferredName(), this.leafValue);
        }
        builder.field(DEFAULT_LEFT.getPreferredName(), this.defaultLeft);
        if (this.leftChild >= 0) {
            builder.field(LEFT_CHILD.getPreferredName(), this.leftChild);
        }
        if (this.rightChild >= 0) {
            builder.field(RIGHT_CHILD.getPreferredName(), this.rightChild);
        }
        builder.field(NUMBER_SAMPLES.getPreferredName(), this.numberSamples);
        builder.endObject();
        return builder;
    }

    private void addOptionalDouble(XContentBuilder builder, ParseField field, double value) throws IOException {
        if (Numbers.isValidDouble(value)) {
            builder.field(field.getPreferredName(), value);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeNode that = (TreeNode)o;
        return Objects.equals(this.operator, that.operator) && Objects.equals(this.threshold, that.threshold) && Objects.equals(this.splitFeature, that.splitFeature) && Objects.equals(this.nodeIndex, that.nodeIndex) && Objects.equals(this.splitGain, that.splitGain) && Arrays.equals(this.leafValue, that.leafValue) && Objects.equals(this.defaultLeft, that.defaultLeft) && Objects.equals(this.leftChild, that.leftChild) && Objects.equals(this.rightChild, that.rightChild) && Objects.equals(this.numberSamples, that.numberSamples);
    }

    public int hashCode() {
        return Objects.hash(this.operator, this.threshold, this.splitFeature, this.splitGain, this.nodeIndex, Arrays.hashCode(this.leafValue), this.defaultLeft, this.leftChild, this.rightChild, this.numberSamples);
    }

    public String toString() {
        return Strings.toString(this);
    }

    public static Builder builder(int nodeIndex) {
        return new Builder(nodeIndex);
    }

    @Override
    public long ramBytesUsed() {
        return SHALLOW_SIZE + (long)(this.leafValue.length * 8);
    }

    public static class Builder {
        private Operator operator;
        private Double threshold;
        private Integer splitFeature;
        private int nodeIndex;
        private Double splitGain;
        private List<Double> leafValue;
        private Boolean defaultLeft;
        private Integer leftChild;
        private Integer rightChild;
        private long numberSamples;

        public Builder(int nodeIndex) {
            this.nodeIndex = nodeIndex;
        }

        private Builder() {
        }

        public Builder setOperator(Operator operator) {
            this.operator = operator;
            return this;
        }

        public Builder setThreshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public Builder setSplitFeature(Integer splitFeature) {
            this.splitFeature = splitFeature;
            return this;
        }

        public Builder setNodeIndex(Integer nodeIndex) {
            this.nodeIndex = nodeIndex;
            return this;
        }

        public Builder setSplitGain(Double splitGain) {
            this.splitGain = splitGain;
            return this;
        }

        public Builder setLeafValue(double leafValue) {
            return this.setLeafValue(Collections.singletonList(leafValue));
        }

        public Builder setLeafValue(List<Double> leafValue) {
            this.leafValue = leafValue;
            return this;
        }

        List<Double> getLeafValue() {
            return this.leafValue;
        }

        public Builder setDefaultLeft(Boolean defaultLeft) {
            this.defaultLeft = defaultLeft;
            return this;
        }

        public Builder setLeftChild(Integer leftChild) {
            this.leftChild = leftChild;
            return this;
        }

        public Integer getLeftChild() {
            return this.leftChild;
        }

        public Builder setRightChild(Integer rightChild) {
            this.rightChild = rightChild;
            return this;
        }

        public Integer getRightChild() {
            return this.rightChild;
        }

        public Builder setNumberSamples(long numberSamples) {
            this.numberSamples = numberSamples;
            return this;
        }

        public void validate() {
            if (this.nodeIndex < 0) {
                throw new IllegalArgumentException("[node_index] must be a non-negative integer.");
            }
            if (this.leftChild == null) {
                if (this.leafValue == null) {
                    throw new IllegalArgumentException("[leaf_value] is required for a leaf node.");
                }
                if (this.leafValue.stream().anyMatch(Objects::isNull)) {
                    throw new IllegalArgumentException("[leaf_value] cannot have null values.");
                }
            } else {
                if (this.leftChild < 0) {
                    throw new IllegalArgumentException("[left_child] must be a non-negative integer.");
                }
                if (this.rightChild != null && this.rightChild < 0) {
                    throw new IllegalArgumentException("[right_child] must be a non-negative integer.");
                }
                if (this.threshold == null) {
                    throw new IllegalArgumentException("[threshold] must exist for non-leaf node.");
                }
            }
        }

        public TreeNode build() {
            this.validate();
            return new TreeNode(this.operator, this.threshold, this.splitFeature, this.nodeIndex, this.splitGain, this.leafValue, this.defaultLeft, this.leftChild, this.rightChild, this.numberSamples);
        }
    }
}

