/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class DataFrameAnalyticsDest
implements Writeable,
ToXContentObject {
    public static final ParseField INDEX = new ParseField("index", new String[0]);
    public static final ParseField RESULTS_FIELD = new ParseField("results_field", new String[0]);
    private static final String DEFAULT_RESULTS_FIELD = "ml";
    private final String index;
    private final String resultsField;

    public static ConstructingObjectParser<DataFrameAnalyticsDest, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser<DataFrameAnalyticsDest, Void> parser = new ConstructingObjectParser<DataFrameAnalyticsDest, Void>("data_frame_analytics_dest", ignoreUnknownFields, a -> new DataFrameAnalyticsDest((String)a[0], (String)a[1]));
        parser.declareString(ConstructingObjectParser.constructorArg(), INDEX);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), RESULTS_FIELD);
        return parser;
    }

    public DataFrameAnalyticsDest(String index, @Nullable String resultsField) {
        this.index = ExceptionsHelper.requireNonNull(index, INDEX);
        if (index.isEmpty()) {
            throw ExceptionsHelper.badRequestException("[{}] must be non-empty", INDEX);
        }
        this.resultsField = resultsField == null ? DEFAULT_RESULTS_FIELD : resultsField;
    }

    public DataFrameAnalyticsDest(StreamInput in) throws IOException {
        this.index = in.readString();
        this.resultsField = in.readString();
    }

    public DataFrameAnalyticsDest(DataFrameAnalyticsDest other) {
        this.index = other.index;
        this.resultsField = other.resultsField;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeString(this.resultsField);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INDEX.getPreferredName(), this.index);
        builder.field(RESULTS_FIELD.getPreferredName(), this.resultsField);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataFrameAnalyticsDest other = (DataFrameAnalyticsDest)o;
        return Objects.equals(this.index, other.index) && Objects.equals(this.resultsField, other.resultsField);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.resultsField);
    }

    public String getIndex() {
        return this.index;
    }

    public String getResultsField() {
        return this.resultsField;
    }
}

