/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;

public class ValidateJobConfigAction
extends ActionType<AcknowledgedResponse> {
    public static final ValidateJobConfigAction INSTANCE = new ValidateJobConfigAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/validate";

    protected ValidateJobConfigAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class Request
    extends ActionRequest {
        private Job job;

        public static Request parseRequest(XContentParser parser) {
            Job.Builder jobBuilder;
            jobBuilder.setId((jobBuilder = Job.STRICT_PARSER.apply(parser, null)).getId() != null ? jobBuilder.getId() : "ok");
            jobBuilder.validateDetectorsAreUnique();
            List<String> invalidJobCreationSettings = jobBuilder.invalidCreateTimeSettings();
            if (!invalidJobCreationSettings.isEmpty()) {
                throw new IllegalArgumentException(Messages.getMessage("The job is configured with fields [{0}] that are illegal to set at job creation", String.join((CharSequence)",", invalidJobCreationSettings)));
            }
            return new Request(jobBuilder.build(new Date()));
        }

        public Request() {
            this.job = null;
        }

        public Request(Job job) {
            this.job = job;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.job = new Job(in);
        }

        public Job getJob() {
            return this.job;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.job.writeTo(out);
        }

        public int hashCode() {
            return Objects.hash(this.job);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Objects.equals(this.job, other.job);
        }
    }
}

