/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class PutTrainedModelVocabularyAction
extends ActionType<AcknowledgedResponse> {
    public static final PutTrainedModelVocabularyAction INSTANCE = new PutTrainedModelVocabularyAction();
    public static final String NAME = "cluster:admin/xpack/ml/trained_models/vocabulary/put";

    private PutTrainedModelVocabularyAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        public static final ParseField VOCABULARY = new ParseField("vocabulary", new String[0]);
        private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("put_trained_model_vocabulary", Builder::new);
        private final String modelId;
        private final List<String> vocabulary;

        public static Request parseRequest(String modelId, XContentParser parser) {
            return PARSER.apply(parser, null).build(modelId);
        }

        public Request(String modelId, List<String> vocabulary) {
            this.modelId = ExceptionsHelper.requireNonNull(modelId, TrainedModelConfig.MODEL_ID);
            this.vocabulary = ExceptionsHelper.requireNonNull(vocabulary, VOCABULARY);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.modelId = in.readString();
            this.vocabulary = in.readStringList();
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.vocabulary.isEmpty()) {
                validationException = ValidateActions.addValidationError("[vocabulary] must not be empty", validationException);
            }
            return validationException;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.modelId, request.modelId) && Objects.equals(this.vocabulary, request.vocabulary);
        }

        public int hashCode() {
            return Objects.hash(this.modelId, this.vocabulary);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.modelId);
            out.writeStringCollection(this.vocabulary);
        }

        public String getModelId() {
            return this.modelId;
        }

        public List<String> getVocabulary() {
            return this.vocabulary;
        }

        static {
            PARSER.declareStringArray(Builder::setVocabulary, VOCABULARY);
        }

        public static class Builder {
            private List<String> vocabulary;

            public Builder setVocabulary(List<String> vocabulary) {
                this.vocabulary = vocabulary;
                return this;
            }

            public Request build(String modelId) {
                return new Request(modelId, this.vocabulary);
            }
        }
    }
}

