/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class MlInfoAction
extends ActionType<Response> {
    public static final MlInfoAction INSTANCE = new MlInfoAction();
    public static final String NAME = "cluster:monitor/xpack/ml/info/get";

    private MlInfoAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private Map<String, Object> info;

        public Response(Map<String, Object> info) {
            this.info = info;
        }

        public Response() {
            this.info = Collections.emptyMap();
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.info = in.readMap();
        }

        public Map<String, Object> getInfo() {
            return this.info;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.info);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.map(this.info);
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.info);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)obj;
            return Objects.equals(this.info, other.info);
        }
    }

    public static class Request
    extends ActionRequest {
        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }
    }
}

