/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm.step.info;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class AllocationInfo
implements ToXContentObject {
    private final long numberOfReplicas;
    private final long numberShardsLeftToAllocate;
    private final boolean allShardsActive;
    private final String message;
    static final ParseField NUMBER_OF_REPLICAS = new ParseField("number_of_replicas", new String[0]);
    static final ParseField SHARDS_TO_ALLOCATE = new ParseField("shards_left_to_allocate", new String[0]);
    static final ParseField ALL_SHARDS_ACTIVE = new ParseField("all_shards_active", new String[0]);
    static final ParseField MESSAGE = new ParseField("message", new String[0]);
    static final ConstructingObjectParser<AllocationInfo, Void> PARSER = new ConstructingObjectParser("allocation_routed_step_info", a -> new AllocationInfo((Long)a[0], (Long)a[1], (Boolean)a[2], (String)a[3]));

    public AllocationInfo(long numberOfReplicas, long numberShardsLeftToAllocate, boolean allShardsActive, String message) {
        this.numberOfReplicas = numberOfReplicas;
        this.numberShardsLeftToAllocate = numberShardsLeftToAllocate;
        this.allShardsActive = allShardsActive;
        this.message = message;
    }

    public static AllocationInfo waitingForActiveShardsAllocationInfo(long numReplicas) {
        return new AllocationInfo(numReplicas, -1L, false, "Waiting for all shard copies to be active");
    }

    public static AllocationInfo allShardsActiveAllocationInfo(long numReplicas, long numberShardsLeftToAllocate) {
        return new AllocationInfo(numReplicas, numberShardsLeftToAllocate, true, "Waiting for [" + numberShardsLeftToAllocate + "] shards to be allocated to nodes matching the given filters");
    }

    public long getNumberOfReplicas() {
        return this.numberOfReplicas;
    }

    public long getNumberShardsLeftToAllocate() {
        return this.numberShardsLeftToAllocate;
    }

    public boolean allShardsActive() {
        return this.allShardsActive;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MESSAGE.getPreferredName(), this.message);
        builder.field(SHARDS_TO_ALLOCATE.getPreferredName(), this.numberShardsLeftToAllocate);
        builder.field(ALL_SHARDS_ACTIVE.getPreferredName(), this.allShardsActive);
        builder.field(NUMBER_OF_REPLICAS.getPreferredName(), this.numberOfReplicas);
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.numberOfReplicas, this.numberShardsLeftToAllocate, this.allShardsActive);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AllocationInfo other = (AllocationInfo)obj;
        return Objects.equals(this.numberOfReplicas, other.numberOfReplicas) && Objects.equals(this.numberShardsLeftToAllocate, other.numberShardsLeftToAllocate) && Objects.equals(this.message, other.message) && Objects.equals(this.allShardsActive, other.allShardsActive);
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUMBER_OF_REPLICAS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), SHARDS_TO_ALLOCATE);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), ALL_SHARDS_ACTIVE);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), MESSAGE);
    }
}

