/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.cluster.routing.allocation.DataTierAllocationDecider;
import org.elasticsearch.xpack.core.ilm.ClusterStateWaitStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.step.info.SingleMessageFieldInfo;

public class WaitForDataTierStep
extends ClusterStateWaitStep {
    public static final String NAME = "wait-for-data-tier";
    private final String tierPreference;

    public WaitForDataTierStep(Step.StepKey key, Step.StepKey nextStepKey, String tierPreference) {
        super(key, nextStepKey);
        this.tierPreference = Objects.requireNonNull(tierPreference);
    }

    @Override
    public ClusterStateWaitStep.Result isConditionMet(Index index, ClusterState clusterState) {
        boolean present = DataTierAllocationDecider.preferredAvailableTier(DataTier.parseTierList(this.tierPreference), clusterState.nodes()).isPresent();
        SingleMessageFieldInfo info = present ? null : new SingleMessageFieldInfo("no nodes for tiers [" + this.tierPreference + "] available");
        return new ClusterStateWaitStep.Result(present, info);
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    String tierPreference() {
        return this.tierPreference;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WaitForDataTierStep that = (WaitForDataTierStep)o;
        return this.tierPreference.equals(that.tierPreference);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.tierPreference);
    }
}

