/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Locale;
import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.ClusterStateActionStep;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.Step;

public class ReplaceDataStreamBackingIndexStep
extends ClusterStateActionStep {
    public static final String NAME = "replace-datastream-backing-index";
    private static final Logger logger = LogManager.getLogger(ReplaceDataStreamBackingIndexStep.class);
    private final BiFunction<String, LifecycleExecutionState, String> targetIndexNameSupplier;

    public ReplaceDataStreamBackingIndexStep(Step.StepKey key, Step.StepKey nextStepKey, BiFunction<String, LifecycleExecutionState, String> targetIndexNameSupplier) {
        super(key, nextStepKey);
        this.targetIndexNameSupplier = targetIndexNameSupplier;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    public BiFunction<String, LifecycleExecutionState, String> getTargetIndexNameSupplier() {
        return this.targetIndexNameSupplier;
    }

    @Override
    public ClusterState performAction(Index index, ClusterState clusterState) {
        IndexMetadata originalIndexMetadata = clusterState.metadata().index(index);
        if (originalIndexMetadata == null) {
            logger.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)NAME, (Object)index.getName());
            return clusterState;
        }
        String originalIndex = index.getName();
        String targetIndexName = this.targetIndexNameSupplier.apply(originalIndex, LifecycleExecutionState.fromIndexMetadata(originalIndexMetadata));
        String policyName = originalIndexMetadata.getSettings().get("index.lifecycle.name");
        IndexAbstraction indexAbstraction = (IndexAbstraction)clusterState.metadata().getIndicesLookup().get(index.getName());
        assert (indexAbstraction != null) : "invalid cluster metadata. index [" + index.getName() + "] was not found";
        IndexAbstraction.DataStream dataStream = indexAbstraction.getParentDataStream();
        if (dataStream == null) {
            String errorMessage = String.format(Locale.ROOT, "index [%s] is not part of a data stream. stopping execution of lifecycle [%s] until the index is added to a data stream", originalIndex, policyName);
            logger.debug(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        assert (dataStream.getWriteIndex() != null) : dataStream.getName() + " has no write index";
        if (dataStream.getWriteIndex().equals(index)) {
            String errorMessage = String.format(Locale.ROOT, "index [%s] is the write index for data stream [%s], pausing ILM execution of lifecycle [%s] until this index is no longer the write index for the data stream via manual or automated rollover", originalIndex, dataStream.getName(), policyName);
            logger.debug(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        IndexMetadata targetIndexMetadata = clusterState.metadata().index(targetIndexName);
        if (targetIndexMetadata == null) {
            String errorMessage = String.format(Locale.ROOT, "target index [%s] doesn't exist. stopping execution of lifecycle [%s] for index [%s]", targetIndexName, policyName, originalIndex);
            logger.debug(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        Metadata.Builder newMetaData = Metadata.builder(clusterState.getMetadata()).put(dataStream.getDataStream().replaceBackingIndex(index, targetIndexMetadata.getIndex()));
        return ClusterState.builder(clusterState).metadata(newMetaData.build(false)).build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.targetIndexNameSupplier);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReplaceDataStreamBackingIndexStep other = (ReplaceDataStreamBackingIndexStep)obj;
        return super.equals(obj) && Objects.equals(this.targetIndexNameSupplier, other.targetIndexNameSupplier);
    }
}

