/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.common.table;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Locale;
import org.elasticsearch.common.Strings;

public final class TableColumnAttributeBuilder {
    private static final String ATTR_DELIM = ";";
    private String aliases;
    private Boolean displayByDefault;
    private String description;
    private String textAlignment;
    private String sibling;

    public static TableColumnAttributeBuilder builder() {
        return new TableColumnAttributeBuilder();
    }

    public static TableColumnAttributeBuilder builder(String description) {
        return new TableColumnAttributeBuilder().setDescription(description);
    }

    public static TableColumnAttributeBuilder builder(String description, boolean display) {
        return new TableColumnAttributeBuilder().setDescription(description).setDisplayByDefault(display);
    }

    public TableColumnAttributeBuilder setAliases(String ... aliases) {
        this.aliases = Strings.arrayToCommaDelimitedString(aliases);
        return this;
    }

    public TableColumnAttributeBuilder setDisplayByDefault(Boolean displayByDefault) {
        this.displayByDefault = displayByDefault;
        return this;
    }

    public TableColumnAttributeBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public TableColumnAttributeBuilder setTextAlignment(TextAlign textAlignment) {
        this.textAlignment = textAlignment.toString();
        return this;
    }

    public TableColumnAttributeBuilder setSibling(String sibling) {
        this.sibling = sibling;
        return this;
    }

    public String build() {
        ArrayList<CallSite> attrs = new ArrayList<CallSite>();
        if (this.aliases != null) {
            attrs.add((CallSite)((Object)("alias:" + this.aliases)));
        }
        if (this.displayByDefault != null) {
            attrs.add((CallSite)((Object)("default:" + this.displayByDefault.toString())));
        }
        if (this.description != null) {
            attrs.add((CallSite)((Object)("desc:" + this.description)));
        }
        if (this.textAlignment != null) {
            attrs.add((CallSite)((Object)("text-align:" + this.textAlignment)));
        }
        if (this.sibling != null) {
            attrs.add((CallSite)((Object)("sibling:" + this.sibling)));
        }
        return String.join((CharSequence)ATTR_DELIM, attrs);
    }

    public static enum TextAlign {
        LEFT,
        RIGHT,
        NONE;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

