/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.completion;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.query.RegexpFlag;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class RegexOptions
implements ToXContentFragment,
Writeable {
    static final ParseField REGEX_OPTIONS = new ParseField("regex", new String[0]);
    private static final ParseField FLAGS_VALUE = new ParseField("flags", "flags_value");
    private static final ParseField MAX_DETERMINIZED_STATES = new ParseField("max_determinized_states", new String[0]);
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser(REGEX_OPTIONS.getPreferredName(), Builder::new);
    private int flagsValue;
    private int maxDeterminizedStates;

    public static Builder builder() {
        return new Builder();
    }

    static RegexOptions parse(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null).build();
    }

    private RegexOptions(int flagsValue, int maxDeterminizedStates) {
        this.flagsValue = flagsValue;
        this.maxDeterminizedStates = maxDeterminizedStates;
    }

    RegexOptions(StreamInput in) throws IOException {
        this.flagsValue = in.readVInt();
        this.maxDeterminizedStates = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.flagsValue);
        out.writeVInt(this.maxDeterminizedStates);
    }

    public int getFlagsValue() {
        return this.flagsValue;
    }

    public int getMaxDeterminizedStates() {
        return this.maxDeterminizedStates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegexOptions that = (RegexOptions)o;
        if (this.flagsValue != that.flagsValue) {
            return false;
        }
        return this.maxDeterminizedStates == that.maxDeterminizedStates;
    }

    public int hashCode() {
        int result = this.flagsValue;
        result = 31 * result + this.maxDeterminizedStates;
        return result;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(REGEX_OPTIONS.getPreferredName());
        builder.field(FLAGS_VALUE.getPreferredName(), this.flagsValue);
        builder.field(MAX_DETERMINIZED_STATES.getPreferredName(), this.maxDeterminizedStates);
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareInt(Builder::setMaxDeterminizedStates, MAX_DETERMINIZED_STATES);
        PARSER.declareField((parser, builder, aVoid) -> {
            if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
                builder.setFlags(parser.text());
            } else if (parser.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                builder.setFlagsValue(parser.intValue());
            } else {
                throw new ElasticsearchParseException(REGEX_OPTIONS.getPreferredName() + " " + FLAGS_VALUE.getPreferredName() + " supports string or number", new Object[0]);
            }
        }, FLAGS_VALUE, ObjectParser.ValueType.VALUE);
    }

    public static class Builder {
        private int flagsValue = 255;
        private int maxDeterminizedStates = 10000;

        public Builder setFlags(String flags) {
            this.flagsValue = RegexpFlag.resolveValue(flags);
            return this;
        }

        private Builder setFlagsValue(int flagsValue) {
            this.flagsValue = flagsValue;
            return this;
        }

        public Builder setMaxDeterminizedStates(int maxDeterminizedStates) {
            if (maxDeterminizedStates < 0) {
                throw new IllegalArgumentException("maxDeterminizedStates must not be negative");
            }
            this.maxDeterminizedStates = maxDeterminizedStates;
            return this;
        }

        public RegexOptions build() {
            return new RegexOptions(this.flagsValue, this.maxDeterminizedStates);
        }
    }
}

