/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.slice;

import com.carrotsearch.hppc.BitMixer;
import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.elasticsearch.search.slice.SliceQuery;

public final class DocValuesSliceQuery
extends SliceQuery {
    public DocValuesSliceQuery(String field, int id, int max) {
        super(field, id, max);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                final SortedNumericDocValues values = DocValues.getSortedNumeric(context.reader(), DocValuesSliceQuery.this.getField());
                DocIdSetIterator approximation = DocIdSetIterator.all(context.reader().maxDoc());
                TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

                    @Override
                    public boolean matches() throws IOException {
                        if (values.advanceExact(this.approximation.docID())) {
                            for (int i = 0; i < values.docValueCount(); ++i) {
                                if (!DocValuesSliceQuery.this.contains(BitMixer.mix((long)values.nextValue()))) continue;
                                return true;
                            }
                            return false;
                        }
                        return DocValuesSliceQuery.this.contains(0L);
                    }

                    @Override
                    public float matchCost() {
                        return 10.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, twoPhase);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, DocValuesSliceQuery.this.getField());
            }
        };
    }
}

