/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.FetchContext;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.FetchSubPhaseProcessor;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.lookup.SourceLookup;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public final class FetchSourcePhase
implements FetchSubPhase {
    @Override
    public FetchSubPhaseProcessor getProcessor(final FetchContext fetchContext) {
        final FetchSourceContext fetchSourceContext = fetchContext.fetchSourceContext();
        if (fetchSourceContext == null || !fetchSourceContext.fetchSource()) {
            return null;
        }
        final String index = fetchContext.getIndexName();
        assert (fetchSourceContext.fetchSource());
        return new FetchSubPhaseProcessor(){
            private int fastPath;

            @Override
            public void setNextReader(LeafReaderContext readerContext) {
            }

            @Override
            public void process(FetchSubPhase.HitContext hitContext) {
                if (!fetchContext.getSearchExecutionContext().isSourceEnabled()) {
                    if (FetchSourcePhase.containsFilters(fetchSourceContext)) {
                        throw new IllegalArgumentException("unable to fetch fields from _source field: _source is disabled in the mappings for index [" + index + "]");
                    }
                    return;
                }
                this.hitExecute(fetchSourceContext, hitContext);
            }

            private void hitExecute(FetchSourceContext fetchSourceContext2, FetchSubPhase.HitContext hitContext) {
                boolean nestedHit = hitContext.hit().getNestedIdentity() != null;
                SourceLookup source = hitContext.sourceLookup();
                if (!nestedHit && !FetchSourcePhase.containsFilters(fetchSourceContext2)) {
                    hitContext.hit().sourceRef(source.internalSourceRef());
                    ++this.fastPath;
                    return;
                }
                Map<String, Object> value = source.filter(fetchSourceContext2);
                if (nestedHit) {
                    value = FetchSourcePhase.this.getNestedSource(value, hitContext);
                }
                try {
                    int initialCapacity = nestedHit ? 1024 : Math.min(1024, source.internalSourceRef().length());
                    hitContext.hit().sourceRef(FetchSourcePhase.objectToBytes(value, source.sourceContentType(), initialCapacity));
                }
                catch (IOException e) {
                    throw new ElasticsearchException("Error filtering source", (Throwable)e, new Object[0]);
                }
            }

            @Override
            public Map<String, Object> getDebugInfo() {
                return Map.of("fast_path", this.fastPath);
            }
        };
    }

    private static boolean containsFilters(FetchSourceContext context) {
        return context.includes().length != 0 || context.excludes().length != 0;
    }

    public static BytesReference objectToBytes(Object value, XContentType xContentType, int initialCapacity) throws IOException {
        BytesStreamOutput streamOutput = new BytesStreamOutput(initialCapacity);
        XContentBuilder builder = new XContentBuilder(xContentType.xContent(), streamOutput);
        if (value != null) {
            builder.value(value);
        } else {
            builder.startObject();
            builder.endObject();
        }
        return BytesReference.bytes(builder);
    }

    private Map<String, Object> getNestedSource(Map<String, Object> sourceAsMap, FetchSubPhase.HitContext hitContext) {
        for (SearchHit.NestedIdentity o = hitContext.hit().getNestedIdentity(); o != null; o = o.getChild()) {
            if ((sourceAsMap = (Map)sourceAsMap.get(o.getField().string())) != null) continue;
            return null;
        }
        return sourceAsMap;
    }
}

