/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public abstract class PipelineAggregator {
    private String name;
    private String[] bucketsPaths;
    private Map<String, Object> metadata;

    protected PipelineAggregator(String name, String[] bucketsPaths, Map<String, Object> metadata) {
        this.name = name;
        this.bucketsPaths = bucketsPaths;
        this.metadata = metadata;
    }

    public String name() {
        return this.name;
    }

    public String[] bucketsPaths() {
        return this.bucketsPaths;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    public abstract InternalAggregation reduce(InternalAggregation var1, InternalAggregation.ReduceContext var2);

    public static class PipelineTree {
        public static final PipelineTree EMPTY = new PipelineTree(Collections.emptyMap(), Collections.emptyList());
        private final Map<String, PipelineTree> subTrees;
        private final List<PipelineAggregator> aggregators;

        public PipelineTree(Map<String, PipelineTree> subTrees, List<PipelineAggregator> aggregators) {
            this.subTrees = subTrees;
            this.aggregators = aggregators;
        }

        public List<PipelineAggregator> aggregators() {
            return this.aggregators;
        }

        public PipelineTree subTree(String name) {
            return this.subTrees.getOrDefault(name, EMPTY);
        }

        public boolean hasSubTrees() {
            return false == this.subTrees.isEmpty();
        }

        public String toString() {
            return "PipelineTree[" + this.aggregators + "," + this.subTrees + "]";
        }
    }

    @FunctionalInterface
    public static interface Parser {
        public static final ParseField BUCKETS_PATH = new ParseField("buckets_path", new String[0]);
        public static final ParseField FORMAT = new ParseField("format", new String[0]);
        public static final ParseField GAP_POLICY = new ParseField("gap_policy", new String[0]);

        public PipelineAggregationBuilder parse(String var1, XContentParser var2) throws IOException;
    }
}

