/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.metrics.ParsedSingleValueNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class ParsedSum
extends ParsedSingleValueNumericMetricsAggregation
implements Sum {
    private static final ObjectParser<ParsedSum, Void> PARSER = new ObjectParser(ParsedSum.class.getSimpleName(), true, ParsedSum::new);

    @Override
    public double getValue() {
        return this.value();
    }

    @Override
    public String getType() {
        return "sum";
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), this.value);
        if (this.valueAsString != null) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.valueAsString);
        }
        return builder;
    }

    public static ParsedSum fromXContent(XContentParser parser, String name) {
        ParsedSum sum = PARSER.apply(parser, null);
        sum.setName(name);
        return sum;
    }

    static {
        ParsedSum.declareSingleValueFields(PARSER, Double.NEGATIVE_INFINITY);
    }
}

