/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.ParsedAggregation;
import org.elasticsearch.search.aggregations.metrics.ScriptedMetric;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class ParsedScriptedMetric
extends ParsedAggregation
implements ScriptedMetric {
    private List<Object> aggregation;
    private static final ObjectParser<ParsedScriptedMetric, Void> PARSER = new ObjectParser(ParsedScriptedMetric.class.getSimpleName(), true, ParsedScriptedMetric::new);

    @Override
    public String getType() {
        return "scripted_metric";
    }

    @Override
    public Object aggregation() {
        assert (this.aggregation.size() == 1);
        return this.aggregation.get(0);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), this.aggregation());
    }

    private static Object parseValue(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        Object value = null;
        if (token == XContentParser.Token.VALUE_NULL) {
            value = null;
        } else if (token.isValue()) {
            if (token == XContentParser.Token.VALUE_STRING) {
                value = parser.text();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                value = parser.numberValue();
            } else if (token == XContentParser.Token.VALUE_BOOLEAN) {
                value = parser.booleanValue();
            } else if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                value = new BytesArray(parser.binaryValue());
            }
        } else if (token == XContentParser.Token.START_OBJECT) {
            value = parser.map();
        } else if (token == XContentParser.Token.START_ARRAY) {
            value = parser.list();
        }
        return value;
    }

    public static ParsedScriptedMetric fromXContent(XContentParser parser, String name) {
        ParsedScriptedMetric aggregation = PARSER.apply(parser, null);
        aggregation.setName(name);
        return aggregation;
    }

    static {
        ParsedScriptedMetric.declareAggregationFields(PARSER);
        PARSER.declareField((agg, value) -> {
            agg.aggregation = Collections.singletonList(value);
        }, ParsedScriptedMetric::parseValue, Aggregation.CommonFields.VALUE, ObjectParser.ValueType.VALUE_OBJECT_ARRAY);
    }
}

