/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;

final class MethodHandlers {
    private final String path;
    private final Map<RestRequest.Method, Map<RestApiVersion, RestHandler>> methodHandlers;

    MethodHandlers(String path) {
        this.path = path;
        this.methodHandlers = new HashMap<RestRequest.Method, Map<RestApiVersion, RestHandler>>(2, 1.0f);
    }

    MethodHandlers addMethod(RestRequest.Method method, RestApiVersion version, RestHandler handler) {
        RestHandler existing = this.methodHandlers.computeIfAbsent(method, k -> new HashMap(1, 1.0f)).putIfAbsent(version, handler);
        if (existing != null) {
            throw new IllegalArgumentException("Cannot replace existing handler for [" + this.path + "] for method: " + method);
        }
        return this;
    }

    RestHandler getHandler(RestRequest.Method method, RestApiVersion version) {
        Map<RestApiVersion, RestHandler> versionToHandlers = this.methodHandlers.get((Object)method);
        if (versionToHandlers == null) {
            return null;
        }
        RestHandler handler = versionToHandlers.get((Object)version);
        return handler == null ? versionToHandlers.get((Object)RestApiVersion.current()) : handler;
    }

    Set<RestRequest.Method> getValidMethods() {
        return this.methodHandlers.keySet();
    }
}

