/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.license.License;
import org.elasticsearch.license.PutLicenseAction;
import org.elasticsearch.license.PutLicenseRequest;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;

public class RestPutLicenseAction
extends BaseRestHandler {
    RestPutLicenseAction() {
    }

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder(RestRequest.Method.POST, "/_license").replaces(RestRequest.Method.POST, "/_xpack/license", RestApiVersion.V_7).build(), RestHandler.Route.builder(RestRequest.Method.PUT, "/_license").replaces(RestRequest.Method.PUT, "/_xpack/license", RestApiVersion.V_7).build());
    }

    @Override
    public String getName() {
        return "put_license";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!request.hasContent()) {
            throw new IllegalArgumentException("The license must be provided in the request body");
        }
        PutLicenseRequest putLicenseRequest = new PutLicenseRequest();
        putLicenseRequest.license(request.content(), request.getXContentType());
        putLicenseRequest.acknowledge(request.paramAsBoolean("acknowledge", false));
        putLicenseRequest.timeout(request.paramAsTime("timeout", putLicenseRequest.timeout()));
        putLicenseRequest.masterNodeTimeout(request.paramAsTime("master_timeout", putLicenseRequest.masterNodeTimeout()));
        if (License.LicenseType.isBasic(putLicenseRequest.license().type())) {
            throw new IllegalArgumentException("Installing basic licenses is no longer allowed. Use the POST /_license/start_basic API to install a basic license that does not expire.");
        }
        return channel -> client.execute(PutLicenseAction.INSTANCE, putLicenseRequest, new RestToXContentListener((RestChannel)channel));
    }
}

