/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import org.elasticsearch.action.support.master.AcknowledgedRequestBuilder;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.license.License;
import org.elasticsearch.license.PutLicenseAction;
import org.elasticsearch.license.PutLicenseRequest;
import org.elasticsearch.protocol.xpack.license.PutLicenseResponse;
import org.elasticsearch.xcontent.XContentType;

public class PutLicenseRequestBuilder
extends AcknowledgedRequestBuilder<PutLicenseRequest, PutLicenseResponse, PutLicenseRequestBuilder> {
    public PutLicenseRequestBuilder(ElasticsearchClient client) {
        this(client, PutLicenseAction.INSTANCE);
    }

    public PutLicenseRequestBuilder(ElasticsearchClient client, PutLicenseAction action) {
        super(client, action, new PutLicenseRequest());
    }

    public PutLicenseRequestBuilder setLicense(License license) {
        ((PutLicenseRequest)this.request).license(license);
        return this;
    }

    public PutLicenseRequestBuilder setLicense(BytesReference licenseSource, XContentType xContentType) {
        ((PutLicenseRequest)this.request).license(licenseSource, xContentType);
        return this;
    }

    public PutLicenseRequestBuilder setAcknowledge(boolean acknowledge) {
        ((PutLicenseRequest)this.request).acknowledge(acknowledge);
        return this;
    }
}

