/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.license.DeleteLicenseAction;
import org.elasticsearch.license.DeleteLicenseRequestBuilder;
import org.elasticsearch.license.GetBasicStatusRequestBuilder;
import org.elasticsearch.license.GetLicenseAction;
import org.elasticsearch.license.GetLicenseRequestBuilder;
import org.elasticsearch.license.GetLicenseResponse;
import org.elasticsearch.license.GetTrialStatusRequestBuilder;
import org.elasticsearch.license.License;
import org.elasticsearch.license.PostStartBasicAction;
import org.elasticsearch.license.PostStartBasicRequest;
import org.elasticsearch.license.PostStartBasicRequestBuilder;
import org.elasticsearch.license.PostStartBasicResponse;
import org.elasticsearch.license.PostStartTrialAction;
import org.elasticsearch.license.PostStartTrialRequest;
import org.elasticsearch.license.PostStartTrialRequestBuilder;
import org.elasticsearch.license.PostStartTrialResponse;
import org.elasticsearch.license.PutLicenseAction;
import org.elasticsearch.license.PutLicenseRequest;
import org.elasticsearch.license.PutLicenseRequestBuilder;
import org.elasticsearch.protocol.xpack.license.DeleteLicenseRequest;
import org.elasticsearch.protocol.xpack.license.GetLicenseRequest;
import org.elasticsearch.protocol.xpack.license.PutLicenseResponse;

public class LicensingClient {
    private final ElasticsearchClient client;

    public LicensingClient(ElasticsearchClient client) {
        this.client = client;
    }

    public PutLicenseRequestBuilder preparePutLicense(License license) {
        return new PutLicenseRequestBuilder(this.client).setLicense(license);
    }

    public void putLicense(PutLicenseRequest request, ActionListener<PutLicenseResponse> listener) {
        this.client.execute(PutLicenseAction.INSTANCE, request, listener);
    }

    public GetLicenseRequestBuilder prepareGetLicense() {
        return new GetLicenseRequestBuilder(this.client);
    }

    public void getLicense(GetLicenseRequest request, ActionListener<GetLicenseResponse> listener) {
        this.client.execute(GetLicenseAction.INSTANCE, request, listener);
    }

    public DeleteLicenseRequestBuilder prepareDeleteLicense() {
        return new DeleteLicenseRequestBuilder(this.client);
    }

    public void deleteLicense(DeleteLicenseRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.client.execute(DeleteLicenseAction.INSTANCE, request, listener);
    }

    public PostStartTrialRequestBuilder preparePostStartTrial() {
        return new PostStartTrialRequestBuilder(this.client);
    }

    public GetTrialStatusRequestBuilder prepareGetStartTrial() {
        return new GetTrialStatusRequestBuilder(this.client);
    }

    public void postStartTrial(PostStartTrialRequest request, ActionListener<PostStartTrialResponse> listener) {
        this.client.execute(PostStartTrialAction.INSTANCE, request, listener);
    }

    public void postStartBasic(PostStartBasicRequest request, ActionListener<PostStartBasicResponse> listener) {
        this.client.execute(PostStartBasicAction.INSTANCE, request, listener);
    }

    public PostStartBasicRequestBuilder preparePostStartBasic() {
        return new PostStartBasicRequestBuilder(this.client);
    }

    public GetBasicStatusRequestBuilder prepareGetStartBasic() {
        return new GetBasicStatusRequestBuilder(this.client);
    }
}

