/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import org.elasticsearch.threadpool.ThreadPool;

public class ExecutorNames {
    private final String getPoolName;
    private final String searchPoolName;
    private final String writePoolName;
    public static ExecutorNames DEFAULT_SYSTEM_INDEX_THREAD_POOLS = new ExecutorNames("system_read", "system_read", "system_write");
    public static ExecutorNames DEFAULT_SYSTEM_DATA_STREAM_THREAD_POOLS = new ExecutorNames("get", "search", "write");
    public static ExecutorNames CRITICAL_SYSTEM_INDEX_THREAD_POOLS = new ExecutorNames("system_critical_read", "system_critical_read", "system_critical_write");

    public ExecutorNames(String getPoolName, String searchPoolName, String writePoolName) {
        if (!ThreadPool.THREAD_POOL_TYPES.containsKey(getPoolName)) {
            throw new IllegalArgumentException(getPoolName + " is not a valid thread pool");
        }
        if (!ThreadPool.THREAD_POOL_TYPES.containsKey(searchPoolName)) {
            throw new IllegalArgumentException(searchPoolName + " is not a valid thread pool");
        }
        if (!ThreadPool.THREAD_POOL_TYPES.containsKey(writePoolName)) {
            throw new IllegalArgumentException(writePoolName + " is not a valid thread pool");
        }
        this.getPoolName = getPoolName;
        this.searchPoolName = searchPoolName;
        this.writePoolName = writePoolName;
    }

    public String threadPoolForGet() {
        return this.getPoolName;
    }

    public String threadPoolForSearch() {
        return this.searchPoolName;
    }

    public String threadPoolForWrite() {
        return this.writePoolName;
    }
}

