/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class TypeQueryV7Builder
extends AbstractQueryBuilder<TypeQueryV7Builder> {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(TypeQueryV7Builder.class);
    public static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Type queries are deprecated, prefer to filter on a field instead.";
    private static final String NAME = "type";
    public static final ParseField NAME_V7 = new ParseField("type", new String[0]).forRestApiVersion(RestApiVersion.equalTo(RestApiVersion.V_7));
    private static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);
    private static final ObjectParser<TypeQueryV7Builder, Void> PARSER = new ObjectParser("type", TypeQueryV7Builder::new);
    private String value;

    public TypeQueryV7Builder() {
    }

    public TypeQueryV7Builder(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(VALUE_FIELD.getPreferredName(), "_doc");
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    @Override
    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        return new MatchNoDocsQuery();
    }

    @Override
    protected boolean doEquals(TypeQueryV7Builder other) {
        return true;
    }

    @Override
    protected int doHashCode() {
        return 0;
    }

    public static TypeQueryV7Builder fromXContent(XContentParser parser) throws IOException {
        deprecationLogger.compatibleCritical("type_query", TYPES_DEPRECATION_MESSAGE, new Object[0]);
        throw new ParsingException(parser.getTokenLocation(), TYPES_DEPRECATION_MESSAGE, new Object[0]);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    public void setValue(String value) {
        this.value = value;
    }

    static {
        PARSER.declareString(QueryBuilder::queryName, AbstractQueryBuilder.NAME_FIELD.forRestApiVersion(RestApiVersion.equalTo(RestApiVersion.V_7)));
        PARSER.declareFloat(QueryBuilder::boost, AbstractQueryBuilder.BOOST_FIELD.forRestApiVersion(RestApiVersion.equalTo(RestApiVersion.V_7)));
        PARSER.declareString(TypeQueryV7Builder::setValue, VALUE_FIELD.forRestApiVersion(RestApiVersion.equalTo(RestApiVersion.V_7)));
    }
}

