/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.elasticsearch.common.Strings;

@Deprecated(since="v8")
@Plugin(name="ESJsonLayout", category="Core", elementType="layout", printObject=true)
public class ESJsonLayout
extends AbstractStringLayout {
    private final PatternLayout patternLayout;
    private String esmessagefields;

    protected ESJsonLayout(String typeName, Charset charset, String[] overrideFields) {
        super(charset);
        this.esmessagefields = String.join((CharSequence)",", overrideFields);
        this.patternLayout = PatternLayout.newBuilder().withPattern(this.pattern(typeName, overrideFields)).withAlwaysWriteExceptions(false).build();
    }

    private String pattern(String type, String[] esmessagefields) {
        if (Strings.isEmpty(type)) {
            throw new IllegalArgumentException("layout parameter 'type_name' cannot be empty");
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("type", this.inQuotes(type));
        map.put("timestamp", this.inQuotes("%d{yyyy-MM-dd'T'HH:mm:ss,SSSZZ}"));
        map.put("level", this.inQuotes("%p"));
        map.put("component", this.inQuotes("%c{1.}"));
        map.put("cluster.name", this.inQuotes("${sys:es.logs.cluster_name}"));
        map.put("node.name", this.inQuotes("%node_name"));
        map.put("message", this.inQuotes("%notEmpty{%enc{%marker}{JSON} }%enc{%.-10000m}{JSON}"));
        for (String key : esmessagefields) {
            map.remove(key);
        }
        return this.createPattern(map, Set.of(esmessagefields));
    }

    private String createPattern(Map<String, Object> map, Set<String> esmessagefields) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        String separator = "";
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!esmessagefields.contains(entry.getKey())) {
                sb.append(separator);
                this.appendField(sb, entry);
            }
            separator = ", ";
        }
        sb.append(this.notEmpty(", %node_and_cluster_id "));
        sb.append(this.notEmpty(", %CustomMapFields "));
        sb.append("%exceptionAsJson ");
        sb.append("}");
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    private void appendField(StringBuilder sb, Map.Entry<String, Object> entry) {
        sb.append(this.jsonKey(entry.getKey()));
        sb.append(entry.getValue().toString());
    }

    private String notEmpty(String value) {
        return "%notEmpty{" + value + "}";
    }

    private CharSequence jsonKey(String s) {
        return this.inQuotes(s) + ": ";
    }

    private String inQuotes(String s) {
        return "\"" + s + "\"";
    }

    @PluginFactory
    public static ESJsonLayout createLayout(String type, Charset charset, String[] overrideFields) {
        return new ESJsonLayout(type, charset, overrideFields);
    }

    PatternLayout getPatternLayout() {
        return this.patternLayout;
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    @Override
    public String toSerializable(LogEvent event) {
        return this.patternLayout.toSerializable(event);
    }

    @Override
    public Map<String, String> getContentFormat() {
        return this.patternLayout.getContentFormat();
    }

    @Override
    public void encode(LogEvent event, ByteBufferDestination destination) {
        this.patternLayout.encode(event, destination);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ESJsonLayout{");
        sb.append("patternLayout=").append(this.patternLayout);
        sb.append('}');
        return sb.toString();
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractStringLayout.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<ESJsonLayout> {
        @PluginAttribute(value="type_name")
        String type;
        @PluginAttribute(value="charset", defaultString="UTF-8")
        Charset charset;
        @PluginAttribute(value="esmessagefields")
        private String overrideFields;

        public Builder() {
            this.setCharset(StandardCharsets.UTF_8);
        }

        @Override
        public ESJsonLayout build() {
            String[] split = Strings.isNullOrEmpty(this.overrideFields) ? new String[]{} : this.overrideFields.split(",");
            return ESJsonLayout.createLayout(this.type, this.charset, split);
        }

        @Override
        public Charset getCharset() {
            return this.charset;
        }

        @Override
        public B setCharset(Charset charset) {
            this.charset = charset;
            return (B)((Builder)this.asBuilder());
        }

        public String getType() {
            return this.type;
        }

        public B setType(String type) {
            this.type = type;
            return (B)((Builder)this.asBuilder());
        }

        public String getOverrideFields() {
            return this.overrideFields;
        }

        public B setOverrideFields(String overrideFields) {
            this.overrideFields = overrideFields;
            return (B)((Builder)this.asBuilder());
        }
    }
}

