/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.document;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class DocumentField
implements Writeable,
Iterable<Object> {
    private final String name;
    private final List<Object> values;
    private List<Object> ignoredValues;

    public DocumentField(StreamInput in) throws IOException {
        this.name = in.readString();
        this.values = in.readList(StreamInput::readGenericValue);
        this.ignoredValues = in.getVersion().onOrAfter(Version.V_7_16_0) ? in.readList(StreamInput::readGenericValue) : Collections.emptyList();
    }

    public DocumentField(String name, List<Object> values) {
        this(name, values, Collections.emptyList());
    }

    public DocumentField(String name, List<Object> values, List<Object> ignoredValues) {
        this.name = Objects.requireNonNull(name, "name must not be null");
        this.values = Objects.requireNonNull(values, "values must not be null");
        this.ignoredValues = Objects.requireNonNull(ignoredValues, "ignoredValues must not be null");
    }

    public String getName() {
        return this.name;
    }

    public <V> V getValue() {
        if (this.values == null || this.values.isEmpty()) {
            return null;
        }
        return (V)this.values.get(0);
    }

    public List<Object> getValues() {
        return this.values;
    }

    @Override
    public Iterator<Object> iterator() {
        return this.values.iterator();
    }

    public List<Object> getIgnoredValues() {
        return this.ignoredValues == Collections.emptyList() ? this.ignoredValues : Collections.unmodifiableList(this.ignoredValues);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeCollection(this.values, StreamOutput::writeGenericValue);
        if (out.getVersion().onOrAfter(Version.V_7_16_0)) {
            out.writeCollection(this.ignoredValues, StreamOutput::writeGenericValue);
        }
    }

    public ToXContentFragment getValidValuesWriter() {
        return new ToXContentFragment(){

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startArray(DocumentField.this.name);
                for (Object value : DocumentField.this.values) {
                    builder.value(value);
                }
                builder.endArray();
                return builder;
            }
        };
    }

    public ToXContentFragment getIgnoredValuesWriter() {
        return new ToXContentFragment(){

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startArray(DocumentField.this.name);
                for (Object value : DocumentField.this.ignoredValues) {
                    builder.value(value);
                }
                builder.endArray();
                return builder;
            }
        };
    }

    public static DocumentField fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser);
        String fieldName = parser.currentName();
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, token, parser);
        ArrayList<Object> values = new ArrayList<Object>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            values.add(XContentParserUtils.parseFieldsValue(parser));
        }
        return new DocumentField(fieldName, values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentField objects = (DocumentField)o;
        return Objects.equals(this.name, objects.name) && Objects.equals(this.values, objects.values) && Objects.equals(this.ignoredValues, objects.ignoredValues);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.values, this.ignoredValues);
    }

    public String toString() {
        return "DocumentField{name='" + this.name + "', values=" + this.values + ", ignoredValues=" + this.ignoredValues + "}";
    }
}

