/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.ObjectHashSet;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.action.AliasesRequest;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiffable;
import org.elasticsearch.cluster.NamedDiffableValueSerializer;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComponentTemplateMetadata;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamAlias;
import org.elasticsearch.cluster.metadata.DataStreamMetadata;
import org.elasticsearch.cluster.metadata.DiffableStringMap;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexGraveyard;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.NodesShutdownMetadata;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.HppcMaps;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.VersionedNamedWriteable;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.gateway.MetadataStateFormat;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.NamedObjectNotFoundException;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;

public class Metadata
implements Iterable<IndexMetadata>,
Diffable<Metadata>,
ToXContentFragment {
    private static final Logger logger = LogManager.getLogger(Metadata.class);
    public static final Runnable ON_NEXT_INDEX_FIND_MAPPINGS_NOOP = () -> {};
    public static final String ALL = "_all";
    public static final String UNKNOWN_CLUSTER_UUID = "_na_";
    public static EnumSet<XContentContext> API_ONLY = EnumSet.of(XContentContext.API);
    public static EnumSet<XContentContext> API_AND_GATEWAY = EnumSet.of(XContentContext.API, XContentContext.GATEWAY);
    public static EnumSet<XContentContext> API_AND_SNAPSHOT = EnumSet.of(XContentContext.API, XContentContext.SNAPSHOT);
    public static EnumSet<XContentContext> ALL_CONTEXTS = EnumSet.allOf(XContentContext.class);
    public static final Setting<Boolean> SETTING_READ_ONLY_SETTING = Setting.boolSetting("cluster.blocks.read_only", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final ClusterBlock CLUSTER_READ_ONLY_BLOCK = new ClusterBlock(6, "cluster read-only (api)", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
    public static final Setting<Boolean> SETTING_READ_ONLY_ALLOW_DELETE_SETTING = Setting.boolSetting("cluster.blocks.read_only_allow_delete", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final ClusterBlock CLUSTER_READ_ONLY_ALLOW_DELETE_BLOCK = new ClusterBlock(13, "cluster read-only / allow delete (api)", false, false, true, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
    public static final Metadata EMPTY_METADATA = Metadata.builder().build();
    public static final String CONTEXT_MODE_PARAM = "context_mode";
    public static final String CONTEXT_MODE_SNAPSHOT = XContentContext.SNAPSHOT.toString();
    public static final String CONTEXT_MODE_GATEWAY = XContentContext.GATEWAY.toString();
    public static final String CONTEXT_MODE_API = XContentContext.API.toString();
    public static final String GLOBAL_STATE_FILE_PREFIX = "global-";
    private static final NamedDiffableValueSerializer<Custom> CUSTOM_VALUE_SERIALIZER = new NamedDiffableValueSerializer<Custom>(Custom.class);
    private final String clusterUUID;
    private final boolean clusterUUIDCommitted;
    private final long version;
    private final CoordinationMetadata coordinationMetadata;
    private final Settings transientSettings;
    private final Settings persistentSettings;
    private final Settings settings;
    private final DiffableStringMap hashesOfConsistentSettings;
    private final ImmutableOpenMap<String, IndexMetadata> indices;
    private final ImmutableOpenMap<String, IndexTemplateMetadata> templates;
    private final ImmutableOpenMap<String, Custom> customs;
    private final transient int totalNumberOfShards;
    private final int totalOpenIndexShards;
    private final String[] allIndices;
    private final String[] visibleIndices;
    private final String[] allOpenIndices;
    private final String[] visibleOpenIndices;
    private final String[] allClosedIndices;
    private final String[] visibleClosedIndices;
    private SortedMap<String, IndexAbstraction> indicesLookup;
    private static final ToXContent.Params FORMAT_PARAMS;
    public static final MetadataStateFormat<Metadata> FORMAT;

    private Metadata(String clusterUUID, boolean clusterUUIDCommitted, long version, CoordinationMetadata coordinationMetadata, Settings transientSettings, Settings persistentSettings, Settings settings, DiffableStringMap hashesOfConsistentSettings, int totalNumberOfShards, int totalOpenIndexShards, ImmutableOpenMap<String, IndexMetadata> indices, ImmutableOpenMap<String, IndexTemplateMetadata> templates, ImmutableOpenMap<String, Custom> customs, String[] allIndices, String[] visibleIndices, String[] allOpenIndices, String[] visibleOpenIndices, String[] allClosedIndices, String[] visibleClosedIndices, SortedMap<String, IndexAbstraction> indicesLookup) {
        this.clusterUUID = clusterUUID;
        this.clusterUUIDCommitted = clusterUUIDCommitted;
        this.version = version;
        this.coordinationMetadata = coordinationMetadata;
        this.transientSettings = transientSettings;
        this.persistentSettings = persistentSettings;
        this.settings = settings;
        this.hashesOfConsistentSettings = hashesOfConsistentSettings;
        this.indices = indices;
        this.customs = customs;
        this.templates = templates;
        this.totalNumberOfShards = totalNumberOfShards;
        this.totalOpenIndexShards = totalOpenIndexShards;
        this.allIndices = allIndices;
        this.visibleIndices = visibleIndices;
        this.allOpenIndices = allOpenIndices;
        this.visibleOpenIndices = visibleOpenIndices;
        this.allClosedIndices = allClosedIndices;
        this.visibleClosedIndices = visibleClosedIndices;
        this.indicesLookup = indicesLookup;
    }

    public Metadata withIncrementedVersion() {
        return new Metadata(this.clusterUUID, this.clusterUUIDCommitted, this.version + 1L, this.coordinationMetadata, this.transientSettings, this.persistentSettings, this.settings, this.hashesOfConsistentSettings, this.totalNumberOfShards, this.totalOpenIndexShards, this.indices, this.templates, this.customs, this.allIndices, this.visibleIndices, this.allOpenIndices, this.visibleOpenIndices, this.allClosedIndices, this.visibleClosedIndices, this.indicesLookup);
    }

    public long version() {
        return this.version;
    }

    public String clusterUUID() {
        return this.clusterUUID;
    }

    public boolean clusterUUIDCommitted() {
        return this.clusterUUIDCommitted;
    }

    public Settings settings() {
        return this.settings;
    }

    public Settings transientSettings() {
        return this.transientSettings;
    }

    public Settings persistentSettings() {
        return this.persistentSettings;
    }

    public Map<String, String> hashesOfConsistentSettings() {
        return this.hashesOfConsistentSettings;
    }

    public CoordinationMetadata coordinationMetadata() {
        return this.coordinationMetadata;
    }

    public boolean hasAlias(String alias) {
        IndexAbstraction indexAbstraction = (IndexAbstraction)this.getIndicesLookup().get(alias);
        if (indexAbstraction != null) {
            return indexAbstraction.getType() == IndexAbstraction.Type.ALIAS;
        }
        return false;
    }

    public boolean equalsAliases(Metadata other) {
        for (IndexMetadata otherIndex : other.indices().values()) {
            IndexMetadata thisIndex = this.index(otherIndex.getIndex());
            if (thisIndex == null) {
                return false;
            }
            if (otherIndex.getAliases().equals(thisIndex.getAliases())) continue;
            return false;
        }
        if (other.dataStreamAliases().size() != this.dataStreamAliases().size()) {
            return false;
        }
        for (DataStreamAlias otherAlias : other.dataStreamAliases().values()) {
            DataStreamAlias thisAlias = this.dataStreamAliases().get(otherAlias.getName());
            if (thisAlias == null) {
                return false;
            }
            if (thisAlias.equals(otherAlias)) continue;
            return false;
        }
        return true;
    }

    public SortedMap<String, IndexAbstraction> getIndicesLookup() {
        if (this.indicesLookup != null) {
            return this.indicesLookup;
        }
        DataStreamMetadata dataStreamMetadata = (DataStreamMetadata)this.custom("data_stream");
        this.indicesLookup = Collections.unmodifiableSortedMap(Builder.buildIndicesLookup(dataStreamMetadata, this.indices));
        return this.indicesLookup;
    }

    public ImmutableOpenMap<String, List<AliasMetadata>> findAllAliases(String[] concreteIndices) {
        return this.findAliases(Strings.EMPTY_ARRAY, concreteIndices);
    }

    public ImmutableOpenMap<String, List<AliasMetadata>> findAliases(AliasesRequest aliasesRequest, String[] concreteIndices) {
        return this.findAliases(aliasesRequest.aliases(), concreteIndices);
    }

    private ImmutableOpenMap<String, List<AliasMetadata>> findAliases(String[] aliases, String[] concreteIndices) {
        assert (aliases != null);
        assert (concreteIndices != null);
        if (concreteIndices.length == 0) {
            return ImmutableOpenMap.of();
        }
        String[] patterns = new String[aliases.length];
        boolean[] include = new boolean[aliases.length];
        for (int i = 0; i < aliases.length; ++i) {
            String alias = aliases[i];
            if (alias.charAt(0) == '-') {
                patterns[i] = alias.substring(1);
                include[i] = false;
                continue;
            }
            patterns[i] = alias;
            include[i] = true;
        }
        boolean matchAllAliases = patterns.length == 0;
        ImmutableOpenMap.Builder mapBuilder = ImmutableOpenMap.builder();
        for (String index : concreteIndices) {
            IndexMetadata indexMetadata = this.indices.get(index);
            ArrayList<AliasMetadata> filteredValues = new ArrayList<AliasMetadata>();
            for (AliasMetadata aliasMetadata : indexMetadata.getAliases().values()) {
                boolean matched = matchAllAliases;
                String alias = aliasMetadata.alias();
                for (int i = 0; i < patterns.length; ++i) {
                    if (include[i]) {
                        if (matched) continue;
                        String pattern = patterns[i];
                        matched = ALL.equals(pattern) || Regex.simpleMatch(pattern, alias);
                        continue;
                    }
                    if (!matched) continue;
                    matched = !Regex.simpleMatch(patterns[i], alias);
                }
                if (!matched) continue;
                filteredValues.add(aliasMetadata);
            }
            if (filteredValues.isEmpty()) continue;
            CollectionUtil.timSort(filteredValues, Comparator.comparing(AliasMetadata::alias));
            mapBuilder.put(index, Collections.unmodifiableList(filteredValues));
        }
        return mapBuilder.build();
    }

    public ImmutableOpenMap<String, MappingMetadata> findMappings(String[] concreteIndices, Function<String, Predicate<String>> fieldFilter, Runnable onNextIndex) {
        assert (concreteIndices != null);
        if (concreteIndices.length == 0) {
            return ImmutableOpenMap.of();
        }
        ImmutableOpenMap.Builder<String, MappingMetadata> indexMapBuilder = ImmutableOpenMap.builder();
        Iterable<String> intersection = HppcMaps.intersection(ObjectHashSet.from((Object[])concreteIndices), this.indices.keys());
        for (String index : intersection) {
            onNextIndex.run();
            IndexMetadata indexMetadata = this.indices.get(index);
            Predicate<String> fieldPredicate = fieldFilter.apply(index);
            indexMapBuilder.put(index, Metadata.filterFields(indexMetadata.mapping(), fieldPredicate));
        }
        return indexMapBuilder.build();
    }

    public ImmutableOpenMap<String, IndexAbstraction.DataStream> findDataStreams(String ... concreteIndices) {
        assert (concreteIndices != null);
        ImmutableOpenMap.Builder<String, IndexAbstraction.DataStream> builder = ImmutableOpenMap.builder();
        SortedMap<String, IndexAbstraction> lookup = this.getIndicesLookup();
        for (String indexName : concreteIndices) {
            IndexAbstraction index = (IndexAbstraction)lookup.get(indexName);
            assert (index != null);
            assert (index.getType() == IndexAbstraction.Type.CONCRETE_INDEX);
            if (index.getParentDataStream() == null) continue;
            builder.put(indexName, index.getParentDataStream());
        }
        return builder.build();
    }

    private static MappingMetadata filterFields(MappingMetadata mappingMetadata, Predicate<String> fieldPredicate) {
        if (mappingMetadata == null) {
            return MappingMetadata.EMPTY_MAPPINGS;
        }
        if (fieldPredicate == MapperPlugin.NOOP_FIELD_PREDICATE) {
            return mappingMetadata;
        }
        Map sourceAsMap = XContentHelper.convertToMap(mappingMetadata.source().compressedReference(), true).v2();
        Map mapping = sourceAsMap.size() == 1 && sourceAsMap.containsKey(mappingMetadata.type()) ? (Map)sourceAsMap.get(mappingMetadata.type()) : sourceAsMap;
        Map properties = (Map)mapping.get("properties");
        if (properties == null || properties.isEmpty()) {
            return mappingMetadata;
        }
        Metadata.filterFields("", properties, fieldPredicate);
        return new MappingMetadata(mappingMetadata.type(), sourceAsMap);
    }

    private static boolean filterFields(String currentPath, Map<String, Object> fields, Predicate<String> fieldPredicate) {
        assert (fieldPredicate != MapperPlugin.NOOP_FIELD_PREDICATE);
        Iterator<Map.Entry<String, Object>> entryIterator = fields.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map map;
            Map.Entry<String, Object> entry = entryIterator.next();
            String newPath = Metadata.mergePaths(currentPath, entry.getKey());
            Object value = entry.getValue();
            boolean mayRemove = true;
            boolean isMultiField = false;
            if (value instanceof Map) {
                map = (Map)value;
                Map properties = (Map)map.get("properties");
                if (properties != null) {
                    mayRemove = Metadata.filterFields(newPath, properties, fieldPredicate);
                } else {
                    Map subFields = (Map)map.get("fields");
                    if (subFields != null) {
                        isMultiField = true;
                        mayRemove = Metadata.filterFields(newPath, subFields, fieldPredicate);
                        if (mayRemove) {
                            map.remove("fields");
                        }
                    }
                }
            } else {
                throw new IllegalStateException("cannot filter mappings, found unknown element of type [" + value.getClass() + "]");
            }
            if (fieldPredicate.test(newPath)) continue;
            if (mayRemove) {
                entryIterator.remove();
                continue;
            }
            if (!isMultiField) continue;
            map = (Map)value;
            Map subFields = (Map)map.get("fields");
            assert (subFields.size() > 0);
            map.put("properties", subFields);
            map.remove("fields");
            map.remove("type");
        }
        return fields.size() == 0;
    }

    private static String mergePaths(String path, String field) {
        if (path.length() == 0) {
            return field;
        }
        return path + "." + field;
    }

    public String[] getConcreteAllIndices() {
        return this.allIndices;
    }

    public String[] getConcreteVisibleIndices() {
        return this.visibleIndices;
    }

    public String[] getConcreteAllOpenIndices() {
        return this.allOpenIndices;
    }

    public String[] getConcreteVisibleOpenIndices() {
        return this.visibleOpenIndices;
    }

    public String[] getConcreteAllClosedIndices() {
        return this.allClosedIndices;
    }

    public String[] getConcreteVisibleClosedIndices() {
        return this.visibleClosedIndices;
    }

    public String resolveWriteIndexRouting(@Nullable String routing, String aliasOrIndex) {
        if (aliasOrIndex == null) {
            return routing;
        }
        IndexAbstraction result = (IndexAbstraction)this.getIndicesLookup().get(aliasOrIndex);
        if (result == null || result.getType() != IndexAbstraction.Type.ALIAS) {
            return routing;
        }
        Index writeIndexName = result.getWriteIndex();
        if (writeIndexName == null) {
            throw new IllegalArgumentException("alias [" + aliasOrIndex + "] does not have a write index");
        }
        AliasMetadata writeIndexAliasMetadata = this.index(writeIndexName).getAliases().get(result.getName());
        if (writeIndexAliasMetadata != null) {
            return Metadata.resolveRouting(routing, aliasOrIndex, writeIndexAliasMetadata);
        }
        return routing;
    }

    public String resolveIndexRouting(@Nullable String routing, String aliasOrIndex) {
        if (aliasOrIndex == null) {
            return routing;
        }
        IndexAbstraction result = (IndexAbstraction)this.getIndicesLookup().get(aliasOrIndex);
        if (result == null || result.getType() != IndexAbstraction.Type.ALIAS) {
            return routing;
        }
        if (result.getIndices().size() > 1) {
            this.rejectSingleIndexOperation(aliasOrIndex, result);
        }
        return Metadata.resolveRouting(routing, aliasOrIndex, AliasMetadata.getFirstAliasMetadata(this, result));
    }

    private static String resolveRouting(@Nullable String routing, String aliasOrIndex, AliasMetadata aliasMd) {
        if (aliasMd.indexRouting() != null) {
            if (aliasMd.indexRouting().indexOf(44) != -1) {
                throw new IllegalArgumentException("index/alias [" + aliasOrIndex + "] provided with routing value [" + aliasMd.getIndexRouting() + "] that resolved to several routing values, rejecting operation");
            }
            if (routing != null && !routing.equals(aliasMd.indexRouting())) {
                throw new IllegalArgumentException("Alias [" + aliasOrIndex + "] has index routing associated with it [" + aliasMd.indexRouting() + "], and was provided with routing value [" + routing + "], rejecting operation");
            }
            return aliasMd.indexRouting();
        }
        return routing;
    }

    private void rejectSingleIndexOperation(String aliasOrIndex, IndexAbstraction result) {
        Object[] indexNames = new String[result.getIndices().size()];
        int i = 0;
        for (Index indexName : result.getIndices()) {
            indexNames[i++] = indexName.getName();
        }
        throw new IllegalArgumentException("Alias [" + aliasOrIndex + "] has more than one index associated with it [" + Arrays.toString(indexNames) + "], can't execute a single index op");
    }

    public boolean hasIndex(String index) {
        return this.indices.containsKey(index);
    }

    public boolean hasIndex(Index index) {
        IndexMetadata metadata = this.index(index.getName());
        return metadata != null && metadata.getIndexUUID().equals(index.getUUID());
    }

    public boolean hasIndexAbstraction(String index) {
        return this.getIndicesLookup().containsKey(index);
    }

    public IndexMetadata index(String index) {
        return this.indices.get(index);
    }

    public IndexMetadata index(Index index) {
        IndexMetadata metadata = this.index(index.getName());
        if (metadata != null && metadata.getIndexUUID().equals(index.getUUID())) {
            return metadata;
        }
        return null;
    }

    public boolean hasIndexMetadata(IndexMetadata indexMetadata) {
        return this.indices.get(indexMetadata.getIndex().getName()) == indexMetadata;
    }

    public IndexMetadata getIndexSafe(Index index) {
        IndexMetadata metadata = this.index(index.getName());
        if (metadata != null) {
            if (metadata.getIndexUUID().equals(index.getUUID())) {
                return metadata;
            }
            throw new IndexNotFoundException(index, (Throwable)new IllegalStateException("index uuid doesn't match expected: [" + index.getUUID() + "] but got: [" + metadata.getIndexUUID() + "]"));
        }
        throw new IndexNotFoundException(index);
    }

    public ImmutableOpenMap<String, IndexMetadata> indices() {
        return this.indices;
    }

    public ImmutableOpenMap<String, IndexMetadata> getIndices() {
        return this.indices();
    }

    public ImmutableOpenMap<String, IndexTemplateMetadata> templates() {
        return this.templates;
    }

    public ImmutableOpenMap<String, IndexTemplateMetadata> getTemplates() {
        return this.templates;
    }

    public Map<String, ComponentTemplate> componentTemplates() {
        return Optional.ofNullable((ComponentTemplateMetadata)this.custom("component_template")).map(ComponentTemplateMetadata::componentTemplates).orElse(Collections.emptyMap());
    }

    public Map<String, ComposableIndexTemplate> templatesV2() {
        return Optional.ofNullable((ComposableIndexTemplateMetadata)this.custom("index_template")).map(ComposableIndexTemplateMetadata::indexTemplates).orElse(Collections.emptyMap());
    }

    public Map<String, DataStream> dataStreams() {
        return Optional.ofNullable((DataStreamMetadata)this.custom("data_stream")).map(DataStreamMetadata::dataStreams).orElse(Collections.emptyMap());
    }

    public Map<String, DataStreamAlias> dataStreamAliases() {
        return Optional.ofNullable((DataStreamMetadata)this.custom("data_stream")).map(DataStreamMetadata::getDataStreamAliases).orElse(Collections.emptyMap());
    }

    public Map<String, SingleNodeShutdownMetadata> nodeShutdowns() {
        return Optional.ofNullable((NodesShutdownMetadata)this.custom("node_shutdown")).map(NodesShutdownMetadata::getAllNodeMetadataMap).orElse(Collections.emptyMap());
    }

    public ImmutableOpenMap<String, Custom> customs() {
        return this.customs;
    }

    public IndexGraveyard indexGraveyard() {
        return (IndexGraveyard)this.custom("index-graveyard");
    }

    public <T extends Custom> T custom(String type) {
        return (T)this.customs.get(type);
    }

    public <T extends Custom> T custom(String type, T defaultValue) {
        return (T)this.customs.getOrDefault(type, defaultValue);
    }

    public int getTotalNumberOfShards() {
        return this.totalNumberOfShards;
    }

    public int getTotalOpenIndexShards() {
        return this.totalOpenIndexShards;
    }

    public boolean routingRequired(String concreteIndex) {
        MappingMetadata mappingMetadata;
        IndexMetadata indexMetadata = this.indices.get(concreteIndex);
        if (indexMetadata != null && (mappingMetadata = indexMetadata.mapping()) != null) {
            return mappingMetadata.routingRequired();
        }
        return false;
    }

    @Override
    public Iterator<IndexMetadata> iterator() {
        return this.indices.valuesIt();
    }

    public static boolean isGlobalStateEquals(Metadata metadata1, Metadata metadata2) {
        if (!metadata1.coordinationMetadata.equals(metadata2.coordinationMetadata)) {
            return false;
        }
        if (!metadata1.persistentSettings.equals(metadata2.persistentSettings)) {
            return false;
        }
        if (!metadata1.hashesOfConsistentSettings.equals(metadata2.hashesOfConsistentSettings)) {
            return false;
        }
        if (!metadata1.templates.equals(metadata2.templates())) {
            return false;
        }
        if (!metadata1.clusterUUID.equals(metadata2.clusterUUID)) {
            return false;
        }
        if (metadata1.clusterUUIDCommitted != metadata2.clusterUUIDCommitted) {
            return false;
        }
        int customCount1 = 0;
        for (ObjectObjectCursor<String, Custom> objectObjectCursor : metadata1.customs) {
            if (!((Custom)objectObjectCursor.value).context().contains((Object)XContentContext.GATEWAY)) continue;
            if (!((Custom)objectObjectCursor.value).equals(metadata2.custom((String)objectObjectCursor.key))) {
                return false;
            }
            ++customCount1;
        }
        int customCount2 = 0;
        for (Custom custom : metadata2.customs.values()) {
            if (!custom.context().contains((Object)XContentContext.GATEWAY)) continue;
            ++customCount2;
        }
        return customCount1 == customCount2;
    }

    public static Metadata snapshot(Metadata metadata, List<String> dataStreams, List<String> indices) {
        Builder builder = Metadata.builder(metadata);
        for (String dsName : dataStreams) {
            DataStream dataStream = metadata.dataStreams().get(dsName);
            if (dataStream == null) {
                throw new IllegalArgumentException("unable to find data stream [" + dsName + "]");
            }
            builder.put(dataStream.snapshot(indices));
        }
        return builder.build();
    }

    @Override
    public Diff<Metadata> diff(Metadata previousState) {
        return new MetadataDiff(previousState, this);
    }

    public static Diff<Metadata> readDiffFrom(StreamInput in) throws IOException {
        return new MetadataDiff(in);
    }

    public static Metadata fromXContent(XContentParser parser) throws IOException {
        return Builder.fromXContent(parser);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Builder.toXContent(this, builder, params);
        return builder;
    }

    public static Metadata readFrom(StreamInput in) throws IOException {
        int i;
        Builder builder = new Builder();
        builder.version = in.readLong();
        builder.clusterUUID = in.readString();
        builder.clusterUUIDCommitted = in.readBoolean();
        builder.coordinationMetadata(new CoordinationMetadata(in));
        builder.transientSettings(Settings.readSettingsFromStream(in));
        builder.persistentSettings(Settings.readSettingsFromStream(in));
        if (in.getVersion().onOrAfter(Version.V_7_3_0)) {
            builder.hashesOfConsistentSettings(DiffableStringMap.readFrom(in));
        }
        int size = in.readVInt();
        for (i = 0; i < size; ++i) {
            builder.put(IndexMetadata.readFrom(in), false);
        }
        size = in.readVInt();
        for (i = 0; i < size; ++i) {
            builder.put(IndexTemplateMetadata.readFrom(in));
        }
        int customSize = in.readVInt();
        for (int i2 = 0; i2 < customSize; ++i2) {
            Custom customIndexMetadata = in.readNamedWriteable(Custom.class);
            builder.putCustom(customIndexMetadata.getWriteableName(), customIndexMetadata);
        }
        return builder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.version);
        out.writeString(this.clusterUUID);
        out.writeBoolean(this.clusterUUIDCommitted);
        this.coordinationMetadata.writeTo(out);
        Settings.writeSettingsToStream(this.transientSettings, out);
        Settings.writeSettingsToStream(this.persistentSettings, out);
        if (out.getVersion().onOrAfter(Version.V_7_3_0)) {
            this.hashesOfConsistentSettings.writeTo(out);
        }
        out.writeVInt(this.indices.size());
        for (IndexMetadata indexMetadata : this) {
            indexMetadata.writeTo(out);
        }
        out.writeVInt(this.templates.size());
        for (IndexTemplateMetadata template : this.templates.values()) {
            template.writeTo(out);
        }
        VersionedNamedWriteable.writeVersionedWritables(out, this.customs);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Metadata metadata) {
        return new Builder(metadata);
    }

    static {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("binary", "true");
        params.put(CONTEXT_MODE_PARAM, CONTEXT_MODE_GATEWAY);
        FORMAT_PARAMS = new ToXContent.MapParams(params);
        FORMAT = new MetadataStateFormat<Metadata>(GLOBAL_STATE_FILE_PREFIX){

            @Override
            public void toXContent(XContentBuilder builder, Metadata state) throws IOException {
                Builder.toXContent(state, builder, FORMAT_PARAMS);
            }

            @Override
            public Metadata fromXContent(XContentParser parser) throws IOException {
                return Builder.fromXContent(parser);
            }
        };
    }

    public static interface Custom
    extends NamedDiffable<Custom>,
    ToXContentFragment {
        public EnumSet<XContentContext> context();
    }

    public static class Builder {
        private String clusterUUID;
        private boolean clusterUUIDCommitted;
        private long version;
        private CoordinationMetadata coordinationMetadata = CoordinationMetadata.EMPTY_METADATA;
        private Settings transientSettings = Settings.EMPTY;
        private Settings persistentSettings = Settings.EMPTY;
        private DiffableStringMap hashesOfConsistentSettings = DiffableStringMap.EMPTY;
        private final ImmutableOpenMap.Builder<String, IndexMetadata> indices;
        private final ImmutableOpenMap.Builder<String, IndexTemplateMetadata> templates;
        private final ImmutableOpenMap.Builder<String, Custom> customs;
        private SortedMap<String, IndexAbstraction> previousIndicesLookup;

        public Builder() {
            this.clusterUUID = Metadata.UNKNOWN_CLUSTER_UUID;
            this.indices = ImmutableOpenMap.builder();
            this.templates = ImmutableOpenMap.builder();
            this.customs = ImmutableOpenMap.builder();
            this.indexGraveyard(IndexGraveyard.builder().build());
            this.previousIndicesLookup = null;
        }

        Builder(Metadata metadata) {
            this.clusterUUID = metadata.clusterUUID;
            this.clusterUUIDCommitted = metadata.clusterUUIDCommitted;
            this.coordinationMetadata = metadata.coordinationMetadata;
            this.transientSettings = metadata.transientSettings;
            this.persistentSettings = metadata.persistentSettings;
            this.hashesOfConsistentSettings = metadata.hashesOfConsistentSettings;
            this.version = metadata.version;
            this.indices = ImmutableOpenMap.builder(metadata.indices);
            this.templates = ImmutableOpenMap.builder(metadata.templates);
            this.customs = ImmutableOpenMap.builder(metadata.customs);
            this.previousIndicesLookup = metadata.getIndicesLookup();
        }

        public Builder put(IndexMetadata.Builder indexMetadataBuilder) {
            indexMetadataBuilder.version(indexMetadataBuilder.version() + 1L);
            IndexMetadata indexMetadata = indexMetadataBuilder.build();
            IndexMetadata previous = this.indices.put(indexMetadata.getIndex().getName(), indexMetadata);
            if (this.unsetPreviousIndicesLookup(previous, indexMetadata)) {
                this.previousIndicesLookup = null;
            }
            return this;
        }

        public Builder put(IndexMetadata indexMetadata, boolean incrementVersion) {
            IndexMetadata previous;
            if (this.indices.get(indexMetadata.getIndex().getName()) == indexMetadata) {
                return this;
            }
            if (incrementVersion) {
                indexMetadata = IndexMetadata.builder(indexMetadata).version(indexMetadata.getVersion() + 1L).build();
            }
            if (this.unsetPreviousIndicesLookup(previous = this.indices.put(indexMetadata.getIndex().getName(), indexMetadata), indexMetadata)) {
                this.previousIndicesLookup = null;
            }
            return this;
        }

        boolean unsetPreviousIndicesLookup(IndexMetadata previous, IndexMetadata current) {
            if (previous == null) {
                return true;
            }
            if (!previous.getAliases().equals(current.getAliases())) {
                return true;
            }
            if (previous.isHidden() != current.isHidden()) {
                return true;
            }
            if (previous.isSystem() != current.isSystem()) {
                return true;
            }
            return previous.getState() != current.getState();
        }

        public IndexMetadata get(String index) {
            return this.indices.get(index);
        }

        public IndexMetadata getSafe(Index index) {
            IndexMetadata indexMetadata = this.get(index.getName());
            if (indexMetadata != null) {
                if (indexMetadata.getIndexUUID().equals(index.getUUID())) {
                    return indexMetadata;
                }
                throw new IndexNotFoundException(index, (Throwable)new IllegalStateException("index uuid doesn't match expected: [" + index.getUUID() + "] but got: [" + indexMetadata.getIndexUUID() + "]"));
            }
            throw new IndexNotFoundException(index);
        }

        public Builder remove(String index) {
            this.previousIndicesLookup = null;
            this.indices.remove(index);
            return this;
        }

        public Builder removeAllIndices() {
            this.previousIndicesLookup = null;
            this.indices.clear();
            return this;
        }

        public Builder indices(ImmutableOpenMap<String, IndexMetadata> indices) {
            this.previousIndicesLookup = null;
            this.indices.putAll(indices);
            return this;
        }

        public Builder put(IndexTemplateMetadata.Builder template) {
            return this.put(template.build());
        }

        public Builder put(IndexTemplateMetadata template) {
            this.templates.put(template.name(), template);
            return this;
        }

        public Builder removeTemplate(String templateName) {
            this.templates.remove(templateName);
            return this;
        }

        public Builder templates(ImmutableOpenMap<String, IndexTemplateMetadata> templates) {
            this.templates.putAll(templates);
            return this;
        }

        public Builder put(String name, ComponentTemplate componentTemplate) {
            Objects.requireNonNull(componentTemplate, "it is invalid to add a null component template: " + name);
            Map existingTemplates = Optional.ofNullable((ComponentTemplateMetadata)this.customs.get("component_template")).map(ctm -> new HashMap<String, ComponentTemplate>(ctm.componentTemplates())).orElse(new HashMap());
            existingTemplates.put(name, componentTemplate);
            this.customs.put("component_template", new ComponentTemplateMetadata(existingTemplates));
            return this;
        }

        public Builder removeComponentTemplate(String name) {
            Map existingTemplates = Optional.ofNullable((ComponentTemplateMetadata)this.customs.get("component_template")).map(ctm -> new HashMap<String, ComponentTemplate>(ctm.componentTemplates())).orElse(new HashMap());
            existingTemplates.remove(name);
            this.customs.put("component_template", new ComponentTemplateMetadata(existingTemplates));
            return this;
        }

        public Builder componentTemplates(Map<String, ComponentTemplate> componentTemplates) {
            this.customs.put("component_template", new ComponentTemplateMetadata(componentTemplates));
            return this;
        }

        public Builder indexTemplates(Map<String, ComposableIndexTemplate> indexTemplates) {
            this.customs.put("index_template", new ComposableIndexTemplateMetadata(indexTemplates));
            return this;
        }

        public Builder put(String name, ComposableIndexTemplate indexTemplate) {
            Objects.requireNonNull(indexTemplate, "it is invalid to add a null index template: " + name);
            Map existingTemplates = Optional.ofNullable((ComposableIndexTemplateMetadata)this.customs.get("index_template")).map(itmd -> new HashMap<String, ComposableIndexTemplate>(itmd.indexTemplates())).orElse(new HashMap());
            existingTemplates.put(name, indexTemplate);
            this.customs.put("index_template", new ComposableIndexTemplateMetadata(existingTemplates));
            return this;
        }

        public Builder removeIndexTemplate(String name) {
            Map existingTemplates = Optional.ofNullable((ComposableIndexTemplateMetadata)this.customs.get("index_template")).map(itmd -> new HashMap<String, ComposableIndexTemplate>(itmd.indexTemplates())).orElse(new HashMap());
            existingTemplates.remove(name);
            this.customs.put("index_template", new ComposableIndexTemplateMetadata(existingTemplates));
            return this;
        }

        public DataStream dataStream(String dataStreamName) {
            this.previousIndicesLookup = null;
            DataStreamMetadata dataStreamMetadata = (DataStreamMetadata)this.customs.get("data_stream");
            if (dataStreamMetadata != null) {
                return dataStreamMetadata.dataStreams().get(dataStreamName);
            }
            return null;
        }

        public Builder dataStreams(Map<String, DataStream> dataStreams, Map<String, DataStreamAlias> dataStreamAliases) {
            this.previousIndicesLookup = null;
            this.customs.put("data_stream", new DataStreamMetadata(dataStreams, dataStreamAliases));
            return this;
        }

        public Builder put(DataStream dataStream) {
            this.previousIndicesLookup = null;
            Objects.requireNonNull(dataStream, "it is invalid to add a null data stream");
            Map existingDataStreams = Optional.ofNullable((DataStreamMetadata)this.customs.get("data_stream")).map(dsmd -> new HashMap<String, DataStream>(dsmd.dataStreams())).orElse(new HashMap());
            existingDataStreams.put(dataStream.getName(), dataStream);
            Map existingDataStreamAliases = Optional.ofNullable((DataStreamMetadata)this.customs.get("data_stream")).map(dsmd -> new HashMap<String, DataStreamAlias>(dsmd.getDataStreamAliases())).orElse(new HashMap());
            this.customs.put("data_stream", new DataStreamMetadata(existingDataStreams, existingDataStreamAliases));
            return this;
        }

        public boolean put(String aliasName, String dataStream, Boolean isWriteDataStream, String filter) {
            this.previousIndicesLookup = null;
            Map existingDataStream = Optional.ofNullable((DataStreamMetadata)this.customs.get("data_stream")).map(dsmd -> new HashMap<String, DataStream>(dsmd.dataStreams())).orElse(new HashMap());
            Map dataStreamAliases = Optional.ofNullable((DataStreamMetadata)this.customs.get("data_stream")).map(dsmd -> new HashMap<String, DataStreamAlias>(dsmd.getDataStreamAliases())).orElse(new HashMap());
            if (!existingDataStream.containsKey(dataStream)) {
                throw new IllegalArgumentException("alias [" + aliasName + "] refers to a non existing data stream [" + dataStream + "]");
            }
            Map<String, Object> filterAsMap = filter != null ? XContentHelper.convertToMap(XContentFactory.xContent(filter), filter, true) : null;
            DataStreamAlias alias = (DataStreamAlias)dataStreamAliases.get(aliasName);
            if (alias == null) {
                String writeDataStream = isWriteDataStream != null && isWriteDataStream != false ? dataStream : null;
                alias = new DataStreamAlias(aliasName, List.of(dataStream), writeDataStream, filterAsMap);
            } else {
                DataStreamAlias copy = alias.update(dataStream, isWriteDataStream, filterAsMap);
                if (copy == alias) {
                    return false;
                }
                alias = copy;
            }
            dataStreamAliases.put(aliasName, alias);
            this.customs.put("data_stream", new DataStreamMetadata(existingDataStream, dataStreamAliases));
            return true;
        }

        public Builder removeDataStream(String name) {
            this.previousIndicesLookup = null;
            Map existingDataStreams = Optional.ofNullable((DataStreamMetadata)this.customs.get("data_stream")).map(dsmd -> new HashMap<String, DataStream>(dsmd.dataStreams())).orElse(new HashMap());
            existingDataStreams.remove(name);
            Map existingDataStreamAliases = Optional.ofNullable((DataStreamMetadata)this.customs.get("data_stream")).map(dsmd -> new HashMap<String, DataStreamAlias>(dsmd.getDataStreamAliases())).orElse(new HashMap());
            HashSet<String> aliasesToDelete = new HashSet<String>();
            ArrayList<DataStreamAlias> aliasesToUpdate = new ArrayList<DataStreamAlias>();
            for (DataStreamAlias alias : existingDataStreamAliases.values()) {
                DataStreamAlias copy = alias.removeDataStream(name);
                if (copy != null) {
                    if (copy == alias) continue;
                    aliasesToUpdate.add(copy);
                    continue;
                }
                aliasesToDelete.add(alias.getName());
            }
            for (DataStreamAlias alias : aliasesToUpdate) {
                existingDataStreamAliases.put(alias.getName(), alias);
            }
            for (String aliasToDelete : aliasesToDelete) {
                existingDataStreamAliases.remove(aliasToDelete);
            }
            this.customs.put("data_stream", new DataStreamMetadata(existingDataStreams, existingDataStreamAliases));
            return this;
        }

        public boolean removeDataStreamAlias(String aliasName, String dataStreamName, boolean mustExist) {
            this.previousIndicesLookup = null;
            Map dataStreamAliases = Optional.ofNullable((DataStreamMetadata)this.customs.get("data_stream")).map(dsmd -> new HashMap<String, DataStreamAlias>(dsmd.getDataStreamAliases())).orElse(new HashMap());
            DataStreamAlias existing = (DataStreamAlias)dataStreamAliases.get(aliasName);
            if (mustExist && existing == null) {
                throw new ResourceNotFoundException("alias [" + aliasName + "] doesn't exist", new Object[0]);
            }
            if (existing == null) {
                return false;
            }
            DataStreamAlias copy = existing.removeDataStream(dataStreamName);
            if (copy == existing) {
                return false;
            }
            if (copy != null) {
                dataStreamAliases.put(aliasName, copy);
            } else {
                dataStreamAliases.remove(aliasName);
            }
            Map existingDataStream = Optional.ofNullable((DataStreamMetadata)this.customs.get("data_stream")).map(dsmd -> new HashMap<String, DataStream>(dsmd.dataStreams())).orElse(new HashMap());
            this.customs.put("data_stream", new DataStreamMetadata(existingDataStream, dataStreamAliases));
            return true;
        }

        public Custom getCustom(String type) {
            return this.customs.get(type);
        }

        public Builder putCustom(String type, Custom custom) {
            this.customs.put(type, Objects.requireNonNull(custom, type));
            return this;
        }

        public Builder removeCustom(String type) {
            this.customs.remove(type);
            return this;
        }

        public Builder customs(ImmutableOpenMap<String, Custom> customs) {
            customs.stream().forEach(entry -> Objects.requireNonNull((Custom)entry.getValue(), (String)entry.getKey()));
            this.customs.putAll(customs);
            return this;
        }

        public Builder indexGraveyard(IndexGraveyard indexGraveyard) {
            this.putCustom("index-graveyard", indexGraveyard);
            return this;
        }

        public IndexGraveyard indexGraveyard() {
            return (IndexGraveyard)this.getCustom("index-graveyard");
        }

        public Builder updateSettings(Settings settings, String ... indices) {
            if (indices == null || indices.length == 0) {
                indices = (String[])this.indices.keys().toArray(String.class);
            }
            for (String index : indices) {
                IndexMetadata indexMetadata = this.indices.get(index);
                if (indexMetadata == null) {
                    throw new IndexNotFoundException(index);
                }
                this.put(IndexMetadata.builder(indexMetadata).settings(Settings.builder().put(indexMetadata.getSettings()).put(settings)));
            }
            return this;
        }

        public Builder updateNumberOfReplicas(int numberOfReplicas, String[] indices) {
            for (String index : indices) {
                IndexMetadata indexMetadata = this.indices.get(index);
                if (indexMetadata == null) {
                    throw new IndexNotFoundException(index);
                }
                this.put(IndexMetadata.builder(indexMetadata).numberOfReplicas(numberOfReplicas));
            }
            return this;
        }

        public Builder coordinationMetadata(CoordinationMetadata coordinationMetadata) {
            this.coordinationMetadata = coordinationMetadata;
            return this;
        }

        public Settings transientSettings() {
            return this.transientSettings;
        }

        public Builder transientSettings(Settings settings) {
            this.transientSettings = settings;
            return this;
        }

        public Settings persistentSettings() {
            return this.persistentSettings;
        }

        public Builder persistentSettings(Settings settings) {
            this.persistentSettings = settings;
            return this;
        }

        public Builder hashesOfConsistentSettings(DiffableStringMap hashesOfConsistentSettings) {
            this.hashesOfConsistentSettings = hashesOfConsistentSettings;
            return this;
        }

        public Builder hashesOfConsistentSettings(Map<String, String> hashesOfConsistentSettings) {
            this.hashesOfConsistentSettings = new DiffableStringMap(hashesOfConsistentSettings);
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public Builder clusterUUID(String clusterUUID) {
            this.clusterUUID = clusterUUID;
            return this;
        }

        public Builder clusterUUIDCommitted(boolean clusterUUIDCommitted) {
            this.clusterUUIDCommitted = clusterUUIDCommitted;
            return this;
        }

        public Builder generateClusterUuidIfNeeded() {
            if (this.clusterUUID.equals(Metadata.UNKNOWN_CLUSTER_UUID)) {
                this.clusterUUID = UUIDs.randomBase64UUID();
            }
            return this;
        }

        public Metadata build() {
            return this.build(true);
        }

        public Metadata build(boolean builtIndicesLookupEagerly) {
            SortedMap<String, IndexAbstraction> indicesLookup;
            HashSet<String> allIndices = new HashSet<String>(this.indices.size());
            ArrayList<String> visibleIndices = new ArrayList<String>();
            ArrayList<String> allOpenIndices = new ArrayList<String>();
            ArrayList<String> visibleOpenIndices = new ArrayList<String>();
            ArrayList<String> allClosedIndices = new ArrayList<String>();
            ArrayList<String> visibleClosedIndices = new ArrayList<String>();
            HashSet allAliases = new HashSet();
            for (ObjectCursor cursor : this.indices.values()) {
                boolean visible;
                IndexMetadata indexMetadata = (IndexMetadata)cursor.value;
                String name = indexMetadata.getIndex().getName();
                boolean added = allIndices.add(name);
                assert (added) : "double index named [" + name + "]";
                boolean bl = visible = !indexMetadata.isHidden();
                if (visible) {
                    visibleIndices.add(name);
                }
                if (indexMetadata.getState() == IndexMetadata.State.OPEN) {
                    allOpenIndices.add(name);
                    if (visible) {
                        visibleOpenIndices.add(name);
                    }
                } else if (indexMetadata.getState() == IndexMetadata.State.CLOSE) {
                    allClosedIndices.add(name);
                    if (visible) {
                        visibleClosedIndices.add(name);
                    }
                }
                indexMetadata.getAliases().keysIt().forEachRemaining(allAliases::add);
            }
            HashSet<String> allDataStreams = new HashSet<String>();
            DataStreamMetadata dataStreamMetadata = (DataStreamMetadata)this.customs.get("data_stream");
            if (dataStreamMetadata != null) {
                for (DataStream dataStream : dataStreamMetadata.dataStreams().values()) {
                    allDataStreams.add(dataStream.getName());
                }
            }
            HashSet aliasDuplicatesWithIndices = new HashSet(allAliases);
            aliasDuplicatesWithIndices.retainAll(allIndices);
            ArrayList<CallSite> duplicates = new ArrayList<CallSite>();
            if (!aliasDuplicatesWithIndices.isEmpty()) {
                for (ObjectCursor cursor : this.indices.values()) {
                    for (Object alias : aliasDuplicatesWithIndices) {
                        if (!((IndexMetadata)cursor.value).getAliases().containsKey((String)alias)) continue;
                        duplicates.add((CallSite)((Object)((String)alias + " (alias of " + ((IndexMetadata)cursor.value).getIndex() + ") conflicts with index")));
                    }
                }
            }
            HashSet aliasDuplicatesWithDataStreams = new HashSet(allAliases);
            aliasDuplicatesWithDataStreams.retainAll(allDataStreams);
            if (!aliasDuplicatesWithDataStreams.isEmpty()) {
                for (Object cursor : this.indices.values()) {
                    for (String alias : aliasDuplicatesWithDataStreams) {
                        if (!((IndexMetadata)((ObjectCursor)cursor).value).getAliases().containsKey(alias)) continue;
                        duplicates.add((CallSite)((Object)(alias + " (alias of " + ((IndexMetadata)((ObjectCursor)cursor).value).getIndex() + ") conflicts with data stream")));
                    }
                }
            }
            HashSet dataStreamDuplicatesWithIndices = new HashSet(allDataStreams);
            dataStreamDuplicatesWithIndices.retainAll(allIndices);
            if (!dataStreamDuplicatesWithIndices.isEmpty()) {
                for (String dataStream : dataStreamDuplicatesWithIndices) {
                    duplicates.add((CallSite)((Object)("data stream [" + dataStream + "] conflicts with index")));
                }
            }
            if (duplicates.size() > 0) {
                throw new IllegalStateException("index, alias, and data stream names need to be unique, but the following duplicates were found [" + Strings.collectionToCommaDelimitedString(duplicates) + "]");
            }
            ImmutableOpenMap<String, IndexMetadata> indices = this.indices.build();
            if (this.previousIndicesLookup != null) {
                assert (this.previousIndicesLookup.equals(Builder.buildIndicesLookup(dataStreamMetadata, indices)));
                indicesLookup = this.previousIndicesLookup;
            } else {
                indicesLookup = builtIndicesLookupEagerly ? Collections.unmodifiableSortedMap(Builder.buildIndicesLookup(dataStreamMetadata, indices)) : null;
            }
            String[] allIndicesArray = allIndices.toArray(Strings.EMPTY_ARRAY);
            String[] visibleIndicesArray = visibleIndices.toArray(Strings.EMPTY_ARRAY);
            String[] allOpenIndicesArray = allOpenIndices.toArray(Strings.EMPTY_ARRAY);
            String[] visibleOpenIndicesArray = visibleOpenIndices.toArray(Strings.EMPTY_ARRAY);
            String[] allClosedIndicesArray = allClosedIndices.toArray(Strings.EMPTY_ARRAY);
            String[] visibleClosedIndicesArray = visibleClosedIndices.toArray(Strings.EMPTY_ARRAY);
            int totalNumberOfShards = 0;
            int totalOpenIndexShards = 0;
            for (IndexMetadata indexMetadata : indices.values()) {
                totalNumberOfShards += indexMetadata.getTotalNumberOfShards();
                if (!IndexMetadata.State.OPEN.equals((Object)indexMetadata.getState())) continue;
                totalOpenIndexShards += indexMetadata.getTotalNumberOfShards();
            }
            return new Metadata(this.clusterUUID, this.clusterUUIDCommitted, this.version, this.coordinationMetadata, this.transientSettings, this.persistentSettings, Settings.builder().put(this.persistentSettings).put(this.transientSettings).build(), this.hashesOfConsistentSettings, totalNumberOfShards, totalOpenIndexShards, indices, this.templates.build(), this.customs.build(), allIndicesArray, visibleIndicesArray, allOpenIndicesArray, visibleOpenIndicesArray, allClosedIndicesArray, visibleClosedIndicesArray, indicesLookup);
        }

        static SortedMap<String, IndexAbstraction> buildIndicesLookup(DataStreamMetadata dataStreamMetadata, ImmutableOpenMap<String, IndexMetadata> indices) {
            IndexAbstraction existing;
            TreeMap<String, IndexAbstraction> indicesLookup = new TreeMap<String, IndexAbstraction>();
            HashMap<String, DataStream> indexToDataStreamLookup = new HashMap<String, DataStream>();
            if (dataStreamMetadata != null && indices.size() > 0) {
                HashMap dataStreamToAliasLookup = new HashMap();
                for (DataStreamAlias dataStreamAlias : dataStreamMetadata.getDataStreamAliases().values()) {
                    List<Index> allIndicesOfAllDataStreams = dataStreamAlias.getDataStreams().stream().map(name -> {
                        List aliases = dataStreamToAliasLookup.computeIfAbsent(name, k -> new LinkedList());
                        aliases.add(alias.getName());
                        return dataStreamMetadata.dataStreams().get(name);
                    }).flatMap(ds -> ds.getIndices().stream()).collect(Collectors.toList());
                    Index writeIndexOfWriteDataStream = null;
                    if (dataStreamAlias.getWriteDataStream() != null) {
                        DataStream writeDataStream = dataStreamMetadata.dataStreams().get(dataStreamAlias.getWriteDataStream());
                        writeIndexOfWriteDataStream = writeDataStream.getWriteIndex();
                    }
                    IndexAbstraction existing2 = indicesLookup.put(dataStreamAlias.getName(), new IndexAbstraction.Alias(dataStreamAlias, allIndicesOfAllDataStreams, writeIndexOfWriteDataStream));
                    assert (existing2 == null) : "duplicate data stream alias for " + dataStreamAlias.getName();
                }
                for (DataStream dataStream : dataStreamMetadata.dataStreams().values()) {
                    assert (!dataStream.getIndices().isEmpty());
                    List<String> aliases = dataStreamToAliasLookup.getOrDefault(dataStream.getName(), List.of());
                    existing = indicesLookup.put(dataStream.getName(), new IndexAbstraction.DataStream(dataStream, aliases));
                    assert (existing == null) : "duplicate data stream for " + dataStream.getName();
                    for (Index i : dataStream.getIndices()) {
                        indexToDataStreamLookup.put(i.getName(), dataStream);
                    }
                }
            }
            HashMap<String, List> aliasToIndices = new HashMap<String, List>();
            for (IndexMetadata indexMetadata : indices.values()) {
                IndexAbstraction.ConcreteIndex index;
                DataStream parent = (DataStream)indexToDataStreamLookup.get(indexMetadata.getIndex().getName());
                if (parent != null) {
                    assert (parent.getIndices().stream().map(Index::getName).collect(Collectors.toList()).contains(indexMetadata.getIndex().getName())) : "Expected data stream [" + parent.getName() + "] to contain index " + indexMetadata.getIndex();
                    index = new IndexAbstraction.ConcreteIndex(indexMetadata, (IndexAbstraction.DataStream)indicesLookup.get(parent.getName()));
                } else {
                    index = new IndexAbstraction.ConcreteIndex(indexMetadata);
                }
                IndexAbstraction existing2 = indicesLookup.put(indexMetadata.getIndex().getName(), index);
                assert (existing2 == null) : "duplicate for " + indexMetadata.getIndex();
                for (ObjectObjectCursor<String, AliasMetadata> objectObjectCursor : indexMetadata.getAliases()) {
                    AliasMetadata aliasMetadata = (AliasMetadata)objectObjectCursor.value;
                    List aliasIndices = aliasToIndices.computeIfAbsent(aliasMetadata.getAlias(), k -> new ArrayList());
                    aliasIndices.add(indexMetadata);
                }
            }
            for (Map.Entry entry : aliasToIndices.entrySet()) {
                AliasMetadata alias = ((IndexMetadata)((List)entry.getValue()).get(0)).getAliases().get((String)entry.getKey());
                existing = indicesLookup.put((String)entry.getKey(), new IndexAbstraction.Alias(alias, (List)entry.getValue()));
                assert (existing == null) : "duplicate for " + (String)entry.getKey();
            }
            Builder.validateDataStreams(indicesLookup, dataStreamMetadata);
            return indicesLookup;
        }

        static void validateDataStreams(SortedMap<String, IndexAbstraction> indicesLookup, @Nullable DataStreamMetadata dsMetadata) {
            List conflictingAliases;
            if (dsMetadata != null && !(conflictingAliases = indicesLookup.values().stream().filter(ia -> ia.getType() == IndexAbstraction.Type.ALIAS).filter(ia -> !ia.isDataStreamRelated()).filter(ia -> {
                for (Index index : ia.getIndices()) {
                    if (((IndexAbstraction)indicesLookup.get(index.getName())).getParentDataStream() == null) continue;
                    return true;
                }
                return false;
            }).map(IndexAbstraction::getName).collect(Collectors.toList())).isEmpty()) {
                throw new IllegalStateException("aliases " + conflictingAliases + " cannot refer to backing indices of data streams");
            }
        }

        public static void toXContent(Metadata metadata, XContentBuilder builder, ToXContent.Params params) throws IOException {
            XContentContext context = XContentContext.valueOf(params.param(Metadata.CONTEXT_MODE_PARAM, CONTEXT_MODE_API));
            if (context == XContentContext.API) {
                builder.startObject("metadata");
            } else {
                builder.startObject("meta-data");
                builder.field("version", metadata.version());
            }
            builder.field("cluster_uuid", metadata.clusterUUID);
            builder.field("cluster_uuid_committed", metadata.clusterUUIDCommitted);
            builder.startObject("cluster_coordination");
            metadata.coordinationMetadata().toXContent(builder, params);
            builder.endObject();
            if (context != XContentContext.API && !metadata.persistentSettings().isEmpty()) {
                builder.startObject("settings");
                metadata.persistentSettings().toXContent(builder, new ToXContent.MapParams(Collections.singletonMap("flat_settings", "true")));
                builder.endObject();
            }
            builder.startObject("templates");
            for (IndexTemplateMetadata indexTemplateMetadata : metadata.templates().values()) {
                IndexTemplateMetadata.Builder.toXContentWithTypes(indexTemplateMetadata, builder, params);
            }
            builder.endObject();
            if (context == XContentContext.API) {
                builder.startObject("indices");
                for (IndexMetadata indexMetadata : metadata) {
                    IndexMetadata.Builder.toXContent(indexMetadata, builder, params);
                }
                builder.endObject();
            }
            for (ObjectObjectCursor objectObjectCursor : metadata.customs()) {
                if (!((Custom)objectObjectCursor.value).context().contains((Object)context)) continue;
                builder.startObject((String)objectObjectCursor.key);
                ((Custom)objectObjectCursor.value).toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }

        public static Metadata fromXContent(XContentParser parser) throws IOException {
            Builder builder = new Builder();
            XContentParser.Token token = parser.currentToken();
            String currentFieldName = parser.currentName();
            if (!"meta-data".equals(currentFieldName)) {
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.nextToken(), parser);
                    token = parser.nextToken();
                }
                currentFieldName = parser.currentName();
            }
            if (!"meta-data".equals(currentFieldName)) {
                throw new IllegalArgumentException("Expected [meta-data] as a field name but got " + currentFieldName);
            }
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("cluster_coordination".equals(currentFieldName)) {
                        builder.coordinationMetadata(CoordinationMetadata.fromXContent(parser));
                        continue;
                    }
                    if ("settings".equals(currentFieldName)) {
                        builder.persistentSettings(Settings.fromXContent(parser));
                        continue;
                    }
                    if ("indices".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.put(IndexMetadata.Builder.fromXContent(parser), false);
                        }
                        continue;
                    }
                    if ("hashes_of_consistent_settings".equals(currentFieldName)) {
                        builder.hashesOfConsistentSettings(parser.mapStrings());
                        continue;
                    }
                    if ("templates".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.put(IndexTemplateMetadata.Builder.fromXContent(parser, parser.currentName()));
                        }
                        continue;
                    }
                    try {
                        Custom custom = parser.namedObject(Custom.class, currentFieldName, null);
                        builder.putCustom(custom.getWriteableName(), custom);
                    }
                    catch (NamedObjectNotFoundException ex) {
                        logger.warn("Skipping unknown custom object with type {}", (Object)currentFieldName);
                        parser.skipChildren();
                    }
                    continue;
                }
                if (token.isValue()) {
                    if ("version".equals(currentFieldName)) {
                        builder.version = parser.longValue();
                        continue;
                    }
                    if ("cluster_uuid".equals(currentFieldName) || "uuid".equals(currentFieldName)) {
                        builder.clusterUUID = parser.text();
                        continue;
                    }
                    if ("cluster_uuid_committed".equals(currentFieldName)) {
                        builder.clusterUUIDCommitted = parser.booleanValue();
                        continue;
                    }
                    throw new IllegalArgumentException("Unexpected field [" + currentFieldName + "]");
                }
                throw new IllegalArgumentException("Unexpected token " + token);
            }
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, parser.nextToken(), parser);
            return builder.build();
        }
    }

    public static enum XContentContext {
        API,
        GATEWAY,
        SNAPSHOT;

    }

    private static class MetadataDiff
    implements Diff<Metadata> {
        private final long version;
        private final String clusterUUID;
        private final boolean clusterUUIDCommitted;
        private final CoordinationMetadata coordinationMetadata;
        private final Settings transientSettings;
        private final Settings persistentSettings;
        private final Diff<DiffableStringMap> hashesOfConsistentSettings;
        private final Diff<ImmutableOpenMap<String, IndexMetadata>> indices;
        private final Diff<ImmutableOpenMap<String, IndexTemplateMetadata>> templates;
        private final Diff<ImmutableOpenMap<String, Custom>> customs;
        private static final DiffableUtils.DiffableValueReader<String, IndexMetadata> INDEX_METADATA_DIFF_VALUE_READER = new DiffableUtils.DiffableValueReader(IndexMetadata::readFrom, IndexMetadata::readDiffFrom);
        private static final DiffableUtils.DiffableValueReader<String, IndexTemplateMetadata> TEMPLATES_DIFF_VALUE_READER = new DiffableUtils.DiffableValueReader(IndexTemplateMetadata::readFrom, IndexTemplateMetadata::readDiffFrom);

        MetadataDiff(Metadata before, Metadata after) {
            this.clusterUUID = after.clusterUUID;
            this.clusterUUIDCommitted = after.clusterUUIDCommitted;
            this.version = after.version;
            this.coordinationMetadata = after.coordinationMetadata;
            this.transientSettings = after.transientSettings;
            this.persistentSettings = after.persistentSettings;
            this.hashesOfConsistentSettings = after.hashesOfConsistentSettings.diff(before.hashesOfConsistentSettings);
            this.indices = DiffableUtils.diff(before.indices, after.indices, DiffableUtils.getStringKeySerializer());
            this.templates = DiffableUtils.diff(before.templates, after.templates, DiffableUtils.getStringKeySerializer());
            this.customs = DiffableUtils.diff(before.customs, after.customs, DiffableUtils.getStringKeySerializer(), CUSTOM_VALUE_SERIALIZER);
        }

        MetadataDiff(StreamInput in) throws IOException {
            this.clusterUUID = in.readString();
            this.clusterUUIDCommitted = in.readBoolean();
            this.version = in.readLong();
            this.coordinationMetadata = new CoordinationMetadata(in);
            this.transientSettings = Settings.readSettingsFromStream(in);
            this.persistentSettings = Settings.readSettingsFromStream(in);
            this.hashesOfConsistentSettings = in.getVersion().onOrAfter(Version.V_7_3_0) ? DiffableStringMap.readDiffFrom(in) : DiffableStringMap.DiffableStringMapDiff.EMPTY;
            this.indices = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), INDEX_METADATA_DIFF_VALUE_READER);
            this.templates = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), TEMPLATES_DIFF_VALUE_READER);
            this.customs = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), CUSTOM_VALUE_SERIALIZER);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.clusterUUID);
            out.writeBoolean(this.clusterUUIDCommitted);
            out.writeLong(this.version);
            this.coordinationMetadata.writeTo(out);
            Settings.writeSettingsToStream(this.transientSettings, out);
            Settings.writeSettingsToStream(this.persistentSettings, out);
            if (out.getVersion().onOrAfter(Version.V_7_3_0)) {
                this.hashesOfConsistentSettings.writeTo(out);
            }
            this.indices.writeTo(out);
            this.templates.writeTo(out);
            this.customs.writeTo(out);
        }

        @Override
        public Metadata apply(Metadata part) {
            Builder builder = Metadata.builder();
            builder.clusterUUID(this.clusterUUID);
            builder.clusterUUIDCommitted(this.clusterUUIDCommitted);
            builder.version(this.version);
            builder.coordinationMetadata(this.coordinationMetadata);
            builder.transientSettings(this.transientSettings);
            builder.persistentSettings(this.persistentSettings);
            builder.hashesOfConsistentSettings(this.hashesOfConsistentSettings.apply(part.hashesOfConsistentSettings));
            builder.indices(this.indices.apply(part.indices));
            builder.templates(this.templates.apply(part.templates));
            builder.customs(this.customs.apply(part.customs));
            return builder.build();
        }
    }

    public static interface NonRestorableCustom
    extends Custom {
    }
}

