/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamAlias;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class DataStreamMetadata
implements Metadata.Custom {
    public static final String TYPE = "data_stream";
    private static final ParseField DATA_STREAM = new ParseField("data_stream", new String[0]);
    private static final ParseField DATA_STREAM_ALIASES = new ParseField("data_stream_aliases", new String[0]);
    private static final ConstructingObjectParser<DataStreamMetadata, Void> PARSER = new ConstructingObjectParser("data_stream", false, args -> {
        Map dataStreams = (Map)args[0];
        Map<String, DataStreamAlias> dataStreamAliases = (Map<String, DataStreamAlias>)args[1];
        if (dataStreamAliases == null) {
            dataStreamAliases = Map.of();
        }
        return new DataStreamMetadata(dataStreams, dataStreamAliases);
    });
    private final Map<String, DataStream> dataStreams;
    private final Map<String, DataStreamAlias> dataStreamAliases;

    public DataStreamMetadata(Map<String, DataStream> dataStreams, Map<String, DataStreamAlias> dataStreamAliases) {
        this.dataStreams = Map.copyOf(dataStreams);
        this.dataStreamAliases = Map.copyOf(dataStreamAliases);
    }

    public DataStreamMetadata(StreamInput in) throws IOException {
        this(in.readMap(StreamInput::readString, DataStream::new), in.readMap(StreamInput::readString, DataStreamAlias::new));
    }

    public Map<String, DataStream> dataStreams() {
        return this.dataStreams;
    }

    public Map<String, DataStreamAlias> getDataStreamAliases() {
        return this.dataStreamAliases;
    }

    @Override
    public Diff<Metadata.Custom> diff(Metadata.Custom before) {
        return new DataStreamMetadataDiff((DataStreamMetadata)before, this);
    }

    public static NamedDiff<Metadata.Custom> readDiffFrom(StreamInput in) throws IOException {
        return new DataStreamMetadataDiff(in);
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.V_7_7_0;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.dataStreams, StreamOutput::writeString, (stream, val) -> val.writeTo(stream));
        out.writeMap(this.dataStreamAliases, StreamOutput::writeString, (stream, val) -> val.writeTo(stream));
    }

    public static DataStreamMetadata fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.xContentValuesMap(DATA_STREAM.getPreferredName(), this.dataStreams);
        builder.startObject(DATA_STREAM_ALIASES.getPreferredName());
        for (Map.Entry<String, DataStreamAlias> dataStream : this.dataStreamAliases.entrySet()) {
            dataStream.getValue().toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.dataStreams, this.dataStreamAliases);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DataStreamMetadata other = (DataStreamMetadata)obj;
        return Objects.equals(this.dataStreams, other.dataStreams) && Objects.equals(this.dataStreamAliases, other.dataStreamAliases);
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> {
            HashMap<String, DataStream> dataStreams = new HashMap<String, DataStream>();
            while (p.nextToken() != XContentParser.Token.END_OBJECT) {
                String name = p.currentName();
                dataStreams.put(name, DataStream.fromXContent(p));
            }
            return dataStreams;
        }, DATA_STREAM);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            HashMap<String, DataStreamAlias> dataStreams = new HashMap<String, DataStreamAlias>();
            while (p.nextToken() != XContentParser.Token.END_OBJECT) {
                DataStreamAlias alias = DataStreamAlias.fromXContent(p);
                dataStreams.put(alias.getName(), alias);
            }
            return dataStreams;
        }, DATA_STREAM_ALIASES);
    }

    static class DataStreamMetadataDiff
    implements NamedDiff<Metadata.Custom> {
        final Diff<Map<String, DataStream>> dataStreamDiff;
        final Diff<Map<String, DataStreamAlias>> dataStreamAliasDiff;

        DataStreamMetadataDiff(DataStreamMetadata before, DataStreamMetadata after) {
            this.dataStreamDiff = DiffableUtils.diff(before.dataStreams, after.dataStreams, DiffableUtils.getStringKeySerializer());
            this.dataStreamAliasDiff = DiffableUtils.diff(before.dataStreamAliases, after.dataStreamAliases, DiffableUtils.getStringKeySerializer());
        }

        DataStreamMetadataDiff(StreamInput in) throws IOException {
            this.dataStreamDiff = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), DataStream::new, DataStream::readDiffFrom);
            this.dataStreamAliasDiff = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), DataStreamAlias::new, DataStreamAlias::readDiffFrom);
        }

        @Override
        public Metadata.Custom apply(Metadata.Custom part) {
            return new DataStreamMetadata(this.dataStreamDiff.apply(((DataStreamMetadata)part).dataStreams), this.dataStreamAliasDiff != null ? this.dataStreamAliasDiff.apply(((DataStreamMetadata)part).dataStreamAliases) : Map.of());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.dataStreamDiff.writeTo(out);
            this.dataStreamAliasDiff.writeTo(out);
        }

        @Override
        public String getWriteableName() {
            return DataStreamMetadata.TYPE;
        }
    }
}

