/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.util.EnumSet;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestStatus;

public class NoMasterBlockService {
    public static final int NO_MASTER_BLOCK_ID = 2;
    public static final ClusterBlock NO_MASTER_BLOCK_WRITES = new ClusterBlock(2, "no master", true, false, false, RestStatus.SERVICE_UNAVAILABLE, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
    public static final ClusterBlock NO_MASTER_BLOCK_ALL = new ClusterBlock(2, "no master", true, true, false, RestStatus.SERVICE_UNAVAILABLE, ClusterBlockLevel.ALL);
    public static final ClusterBlock NO_MASTER_BLOCK_METADATA_WRITES = new ClusterBlock(2, "no master", true, false, false, RestStatus.SERVICE_UNAVAILABLE, EnumSet.of(ClusterBlockLevel.METADATA_WRITE));
    public static final Setting<ClusterBlock> NO_MASTER_BLOCK_SETTING = new Setting<ClusterBlock>("cluster.no_master_block", "write", NoMasterBlockService::parseNoMasterBlock, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile ClusterBlock noMasterBlock;

    public NoMasterBlockService(Settings settings, ClusterSettings clusterSettings) {
        this.noMasterBlock = NO_MASTER_BLOCK_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(NO_MASTER_BLOCK_SETTING, this::setNoMasterBlock);
    }

    private static ClusterBlock parseNoMasterBlock(String value) {
        switch (value) {
            case "all": {
                return NO_MASTER_BLOCK_ALL;
            }
            case "write": {
                return NO_MASTER_BLOCK_WRITES;
            }
            case "metadata_write": {
                return NO_MASTER_BLOCK_METADATA_WRITES;
            }
        }
        throw new IllegalArgumentException("invalid no-master block [" + value + "], must be one of [all, write, metadata_write]");
    }

    public ClusterBlock getNoMasterBlock() {
        return this.noMasterBlock;
    }

    private void setNoMasterBlock(ClusterBlock noMasterBlock) {
        this.noMasterBlock = noMasterBlock;
    }
}

