/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BytesRef;

public abstract class VectorValues
extends DocIdSetIterator {
    public static int MAX_DIMENSIONS = 1024;
    public static final VectorValues EMPTY = new VectorValues(){

        @Override
        public int size() {
            return 0;
        }

        @Override
        public int dimension() {
            return 0;
        }

        @Override
        public float[] vectorValue() {
            throw new IllegalStateException("Attempt to get vectors from EMPTY values (which was not advanced)");
        }

        @Override
        public int docID() {
            throw new IllegalStateException("VectorValues is EMPTY, and not positioned on a doc");
        }

        @Override
        public int nextDoc() {
            return Integer.MAX_VALUE;
        }

        @Override
        public int advance(int target) {
            return Integer.MAX_VALUE;
        }

        @Override
        public long cost() {
            return 0L;
        }
    };

    protected VectorValues() {
    }

    public abstract int dimension();

    public abstract int size();

    public abstract float[] vectorValue() throws IOException;

    public BytesRef binaryValue() throws IOException {
        throw new UnsupportedOperationException();
    }
}

